/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.tile.TileConjured;

public class BlockConjured
extends Block
implements IWaterLoggable {
    public static final BooleanProperty SOLID = BooleanProperty.func_177716_a((String)"solid");
    public static final BooleanProperty LIGHT = BooleanProperty.func_177716_a((String)"light");
    public static final BooleanProperty BLOCK_UP = BooleanProperty.func_177716_a((String)"block_up");
    public static final BooleanProperty BLOCK_DOWN = BooleanProperty.func_177716_a((String)"block_down");
    public static final BooleanProperty BLOCK_NORTH = BooleanProperty.func_177716_a((String)"block_north");
    public static final BooleanProperty BLOCK_SOUTH = BooleanProperty.func_177716_a((String)"block_south");
    public static final BooleanProperty BLOCK_WEST = BooleanProperty.func_177716_a((String)"block_west");
    public static final BooleanProperty BLOCK_EAST = BooleanProperty.func_177716_a((String)"block_east");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape LIGHT_SHAPE = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public BlockConjured(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)LIGHT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOLID, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BLOCK_DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BLOCK_UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BLOCK_EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BLOCK_WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BLOCK_NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BLOCK_SOUTH, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity inWorld = worldIn.func_175625_s(pos);
        if (inWorld instanceof TileConjured) {
            ((TileConjured)inWorld).doParticles();
        }
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        TileEntity inWorld = world.func_175625_s(pos);
        if (inWorld instanceof TileConjured) {
            int color = Psi.proxy.getColorForColorizer(((TileConjured)inWorld).colorizer);
            return new float[]{(float)PsiRenderHelper.r(color) / 255.0f, (float)PsiRenderHelper.g(color) / 255.0f, (float)PsiRenderHelper.b(color) / 255.0f};
        }
        return null;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        world.func_217377_a(pos, false);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SOLID, LIGHT, BLOCK_UP, BLOCK_DOWN, BLOCK_NORTH, BLOCK_SOUTH, BLOCK_WEST, BLOCK_EAST, WATERLOGGED});
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        BooleanProperty prop;
        switch (facing) {
            default: {
                prop = BLOCK_DOWN;
                break;
            }
            case UP: {
                prop = BLOCK_UP;
                break;
            }
            case NORTH: {
                prop = BLOCK_NORTH;
                break;
            }
            case SOUTH: {
                prop = BLOCK_SOUTH;
                break;
            }
            case WEST: {
                prop = BLOCK_WEST;
                break;
            }
            case EAST: {
                prop = BLOCK_EAST;
            }
        }
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (state.func_177230_c() == facingState.func_177230_c() && state.func_177229_b((Property)LIGHT) == facingState.func_177229_b((Property)LIGHT) && state.func_177229_b((Property)SOLID) == facingState.func_177229_b((Property)SOLID)) {
            return (BlockState)state.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(false));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIGHT) != false ? 15 : 0;
    }

    @Nonnull
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)SOLID) != false ? VoxelShapes.func_197868_b() : VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)SOLID) != false ? VoxelShapes.func_197868_b() : LIGHT_SHAPE;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull BlockState state, IBlockReader world) {
        return new TileConjured();
    }
}

