/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.fx;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import vazkii.psi.client.fx.ModParticles;

public class SparkleParticleData
implements IParticleData {
    public static final Codec<SparkleParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.r)), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.g)), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.b)), (App)Codec.INT.fieldOf("m").forGetter(d -> d.m), (App)Codec.DOUBLE.fieldOf("mx").forGetter(d -> d.mx), (App)Codec.DOUBLE.fieldOf("my").forGetter(d -> d.my), (App)Codec.DOUBLE.fieldOf("mz").forGetter(d -> d.mz)).apply((Applicative)instance, SparkleParticleData::new));
    public final float size;
    public final float r;
    public final float g;
    public final float b;
    public final int m;
    public final double mx;
    public final double my;
    public final double mz;
    public static final IParticleData.IDeserializer<SparkleParticleData> DESERIALIZER = new IParticleData.IDeserializer<SparkleParticleData>(){

        @Nonnull
        public SparkleParticleData deserialize(@Nonnull ParticleType<SparkleParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            int m = reader.readInt();
            reader.expect(' ');
            double mx = reader.readDouble();
            reader.expect(' ');
            double my = reader.readDouble();
            reader.expect(' ');
            double mz = reader.readDouble();
            return new SparkleParticleData(size, r, g, b, m, mx, my, mz);
        }

        public SparkleParticleData read(@Nonnull ParticleType<SparkleParticleData> type, PacketBuffer buf) {
            return new SparkleParticleData(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
    };

    public static SparkleParticleData sparkle(float size, float r, float g, float b, int m, double mx, double my, double mz) {
        return new SparkleParticleData(size, r, g, b, m, mx, my, mz);
    }

    public SparkleParticleData(float size, float r, float g, float b, int m, double mx, double my, double mz) {
        this.size = size;
        this.r = r;
        this.g = g;
        this.b = b;
        this.m = m;
        this.mx = mx;
        this.my = my;
        this.mz = mz;
    }

    @Nonnull
    public ParticleType<SparkleParticleData> func_197554_b() {
        return ModParticles.SPARKLE;
    }

    public void func_197553_a(PacketBuffer buf) {
        buf.writeFloat(this.size);
        buf.writeFloat(this.r);
        buf.writeFloat(this.g);
        buf.writeFloat(this.b);
        buf.writeInt(this.m);
        buf.writeDouble(this.mx);
        buf.writeDouble(this.my);
        buf.writeDouble(this.mz);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %d %.2f %.2f %.2f", this.func_197554_b().getRegistryName(), Float.valueOf(this.size), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), this.m, this.mx, this.my, this.mz);
    }
}

