/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;

public interface ISpellAcceptor {
    public static boolean isAcceptor(ItemStack stack) {
        return !stack.func_190926_b() && stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY).isPresent();
    }

    public static boolean isContainer(ItemStack stack) {
        return stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY).map(ISpellAcceptor::castableFromSocket).orElse(false);
    }

    public static boolean hasSpell(ItemStack stack) {
        return stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY).map(ISpellAcceptor::containsSpell).orElse(false);
    }

    public static ISpellAcceptor acceptor(ItemStack stack) {
        return (ISpellAcceptor)stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    public void setSpell(PlayerEntity var1, Spell var2);

    default public boolean castableFromSocket() {
        return false;
    }

    @Nullable
    default public Spell getSpell() {
        return null;
    }

    default public boolean containsSpell() {
        return false;
    }

    default public ArrayList<Entity> castSpell(SpellContext context) {
        return null;
    }

    default public double getCostModifier() {
        return 1.0;
    }

    default public boolean isCADOnlyContainer() {
        return false;
    }

    default public boolean requiresSneakForSpellSet() {
        return false;
    }
}

