/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.entity;

import net.minecraft.entity.Entity;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.AdditiveMotionHandler;

public class PieceTrickAddMotion
extends PieceTrick {
    public static final double MULTIPLIER = 0.3;
    SpellParam<Entity> target;
    SpellParam<Vector3> direction;
    SpellParam<Number> speed;

    public PieceTrickAddMotion(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam(this.direction);
        this.speed = new ParamNumber("psi.spellparam.speed", SpellParam.RED, false, true);
        this.addParam(this.speed);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double speedVal = (Double)this.getParamEvaluation(this.speed);
        if (speedVal == null) {
            speedVal = 1.0;
        }
        double absSpeed = Math.abs(speedVal);
        int dc = 0;
        if (!meta.getFlag("psi.addmotion")) {
            meta.setFlag("psi.addmotion", true);
            dc = 3;
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)absSpeed * 50);
        meta.addStat(EnumSpellStat.COST, (int)Math.max(1.0, absSpeed * 90.0 - (double)dc));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity targetVal = this.getParamValue(context, this.target);
        Vector3 directionVal = this.getParamValue(context, this.direction);
        double speedVal = this.getParamValue(context, this.speed).doubleValue();
        PieceTrickAddMotion.addMotion(context, targetVal, directionVal, speedVal);
        return null;
    }

    public static void addMotion(SpellContext context, Entity e, Vector3 dir, double speed) throws SpellRuntimeException {
        context.verifyEntity(e);
        if (!context.isInRadius(e)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        dir = dir.copy().normalize().multiply(0.3 * speed);
        if (Math.abs(dir.y) > 1.0E-4) {
            if (e.func_213322_ci().func_82617_b() + dir.y >= 0.0) {
                e.field_70143_R = 0.0f;
            } else if (dir.y > 0.0) {
                double magicnumber = 0.25510204081632654;
                double yvel = (e.func_213322_ci().func_82617_b() + dir.y) * magicnumber + 1.0;
                if (yvel > 0.0) {
                    float newfall = (float)(-(49.0 / magicnumber) + (49.0 * yvel - Math.log(yvel) / Math.log(4.0 * magicnumber)) / magicnumber);
                    e.field_70143_R = Math.min(e.field_70143_R, Math.max(0.0f, newfall));
                }
            }
        }
        AdditiveMotionHandler.addMotion(e, dir.x, dir.y, dir.z);
    }
}

