/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickSmite
extends PieceTrick {
    SpellParam<Vector3> position;

    public PieceTrickSmite(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 100);
        meta.addStat(EnumSpellStat.COST, 400);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = this.getParamValue(context, this.position);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((RegistryKey)context.caster.func_130014_f_().func_234923_W_(), (IWorld)context.caster.func_130014_f_(), (BlockPos)positionVal.toBlockPos()), context.caster.func_130014_f_().func_180495_p(positionVal.toBlockPos().func_177972_a(Direction.UP)), (Entity)context.caster);
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        if (placeEvent.isCanceled()) {
            return null;
        }
        if (context.caster.func_130014_f_() instanceof ServerWorld) {
            LightningBoltEntity lightning = new LightningBoltEntity(EntityType.field_200728_aG, context.caster.field_70170_p);
            lightning.func_226288_n_(positionVal.x, positionVal.y, positionVal.z);
            ((ServerWorld)context.caster.func_130014_f_()).func_217376_c((Entity)lightning);
        }
        return null;
    }
}

