/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.other;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.IGenericRedirector;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.param.ParamAny;

public class PieceCrossConnector
extends SpellPiece
implements IGenericRedirector {
    SpellParam<SpellParam.Any> in1;
    SpellParam<SpellParam.Any> out1;
    SpellParam<SpellParam.Any> in2;
    SpellParam<SpellParam.Any> out2;
    private static final int LINE_ONE = 0xA0A0A0;
    private static final int LINE_TWO = 10502399;

    public PieceCrossConnector(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.in1 = new ParamAny("psi.spellparam.from1", 0xA0A0A0, false);
        this.addParam(this.in1);
        this.out1 = new ParamAny("psi.spellparam.to1", 0xA0A0A0, false);
        this.addParam(this.out1);
        this.in2 = new ParamAny("psi.spellparam.from2", 10502399, false);
        this.addParam(this.in2);
        this.out2 = new ParamAny("psi.spellparam.to2", 10502399, false);
        this.addParam(this.out2);
    }

    @Override
    public String getSortingName() {
        return "00000000000";
    }

    @Override
    public ITextComponent getEvaluationTypeString() {
        return new TranslationTextComponent("psi.datatype.any");
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
    }

    @Override
    public void drawAdditional(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        this.drawSide(ms, buffers, (SpellParam.Side)((Object)this.paramSides.get(this.in1)), light, 0xA0A0A0);
        this.drawSide(ms, buffers, (SpellParam.Side)((Object)this.paramSides.get(this.out1)), light, 0xA0A0A0);
        this.drawSide(ms, buffers, (SpellParam.Side)((Object)this.paramSides.get(this.in2)), light, 10502399);
        this.drawSide(ms, buffers, (SpellParam.Side)((Object)this.paramSides.get(this.out2)), light, 10502399);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawSide(MatrixStack ms, IRenderTypeBuffer buffers, SpellParam.Side side, int light, int color) {
        if (side.isEnabled()) {
            RenderMaterial material = new RenderMaterial(ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS, new ResourceLocation("psi:spell/connector_lines"));
            IVertexBuilder buffer = material.func_229311_a_(buffers, ignored -> SpellPiece.getLayer());
            float minU = 0.0f;
            float minV = 0.0f;
            switch (side) {
                case LEFT: {
                    minU = 0.5f;
                    break;
                }
                default: {
                    break;
                }
                case TOP: {
                    minV = 0.5f;
                    break;
                }
                case BOTTOM: {
                    minU = 0.5f;
                    minV = 0.5f;
                }
            }
            float maxU = minU + 0.5f;
            float maxV = minV + 0.5f;
            float r = (float)PsiRenderHelper.r(color) / 255.0f;
            float g = (float)PsiRenderHelper.g(color) / 255.0f;
            float b = (float)PsiRenderHelper.b(color) / 255.0f;
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            buffer.func_227888_a_(mat, 0.0f, 16.0f, 0.0f).func_227885_a_(r, g, b, 1.0f);
            buffer.func_225583_a_(minU, maxV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, 16.0f, 16.0f, 0.0f).func_227885_a_(r, g, b, 1.0f);
            buffer.func_225583_a_(maxU, maxV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, 16.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, 1.0f);
            buffer.func_225583_a_(maxU, minV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, 1.0f);
            buffer.func_225583_a_(minU, minV).func_227886_a_(light).func_181675_d();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawParams(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        this.drawParam(ms, buffers, light, this.in1);
        this.drawParam(ms, buffers, light, this.in2);
    }

    public void drawParam(MatrixStack ms, IRenderTypeBuffer buffers, int light, SpellParam<?> param) {
        IVertexBuilder buffer = buffers.getBuffer(PsiAPI.internalHandler.getProgrammerLayer());
        SpellParam.Side side = (SpellParam.Side)((Object)this.paramSides.get(param));
        if (side.isEnabled()) {
            int minX = 4;
            int minY = 4;
            int maxX = (minX += side.offx * 9) + 8;
            int maxY = (minY += side.offy * 9) + 8;
            float wh = 8.0f;
            float minU = (float)side.u / 256.0f;
            float minV = (float)side.v / 256.0f;
            float maxU = ((float)side.u + wh) / 256.0f;
            float maxV = ((float)side.v + wh) / 256.0f;
            int r = PsiRenderHelper.r(param.color);
            int g = PsiRenderHelper.g(param.color);
            int b = PsiRenderHelper.b(param.color);
            int a = 255;
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            buffer.func_227888_a_(mat, (float)minX, (float)maxY, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, (float)maxX, (float)maxY, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, (float)maxX, (float)minY, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, (float)minX, (float)minY, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_227886_a_(light).func_181675_d();
        }
    }

    @Override
    public EnumPieceType getPieceType() {
        return EnumPieceType.CONNECTOR;
    }

    @Override
    public SpellParam.Side remapSide(SpellParam.Side inputSide) {
        if (((SpellParam.Side)((Object)this.paramSides.get(this.out1))).getOpposite() == inputSide) {
            return (SpellParam.Side)((Object)this.paramSides.get(this.in1));
        }
        if (((SpellParam.Side)((Object)this.paramSides.get(this.out2))).getOpposite() == inputSide) {
            return (SpellParam.Side)((Object)this.paramSides.get(this.in2));
        }
        return SpellParam.Side.OFF;
    }

    @Override
    public Class<?> getEvaluationType() {
        return null;
    }

    @Override
    public Object evaluate() {
        return null;
    }

    @Override
    public Object execute(SpellContext context) {
        return null;
    }
}

