/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.LazyValue;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.exosuit.IPsiEventArmor;
import vazkii.psi.api.exosuit.PsiArmorEvent;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.client.model.ModelPsimetalExosuit;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.tool.IPsimetalTool;
import vazkii.psi.common.item.tool.ToolSocketable;

public class ItemPsimetalArmor
extends ArmorItem
implements IPsimetalTool,
IPsiEventArmor {
    public final EquipmentSlotType type;
    private final LazyValue<BipedModel<?>> model;
    private static final String TAG_TIMES_CAST = "timesCast";

    public ItemPsimetalArmor(EquipmentSlotType type, Item.Properties props) {
        this(type, PsiAPI.PSIMETAL_ARMOR_MATERIAL, props);
    }

    public ItemPsimetalArmor(EquipmentSlotType type, IArmorMaterial mat, Item.Properties props) {
        super(mat, type, props);
        this.type = type;
        this.model = (LazyValue)DistExecutor.runForDist(() -> () -> new LazyValue(() -> this.provideArmorModelForSlot(type)), () -> () -> null);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage > stack.func_77958_k()) {
            damage = stack.func_77952_i();
        }
        super.setDamage(stack, damage);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (!this.isEnabled(stack)) {
            modifiers.removeAll((Object)Attributes.field_233826_i_);
            modifiers.removeAll((Object)Attributes.field_233827_j_);
        }
        return modifiers;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        String name = super.func_77667_c(stack);
        if (!this.isEnabled(stack)) {
            name = name + ".broken";
        }
        return name;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IPsimetalTool.regen(stack, entityIn);
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ArmorSocketable(stack, 3);
    }

    public void cast(ItemStack stack, PsiArmorEvent event) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(event.getPlayer());
        ItemStack playerCad = PsiAPI.getPlayerCAD(event.getPlayer());
        if (this.isEnabled(stack) && !playerCad.func_190926_b()) {
            int timesCast = stack.func_196082_o().func_74762_e(TAG_TIMES_CAST);
            ItemStack bullet = ISocketable.socketable(stack).getSelectedBullet();
            ItemCAD.cast(event.getPlayer().func_130014_f_(), event.getPlayer(), data, bullet, playerCad, this.getCastCooldown(stack), 0, this.getCastVolume(), context -> {
                context.tool = stack;
                context.attackingEntity = event.attacker;
                context.damageTaken = event.damage;
                context.loopcastIndex = timesCast;
            }, (int)((double)data.calculateDamageDeduction((float)event.damage) * 0.75));
            stack.func_196082_o().func_74768_a(TAG_TIMES_CAST, timesCast + 1);
        }
    }

    @Override
    public void onEvent(ItemStack stack, PsiArmorEvent event) {
        if (event.type.equals(this.getTrueEvent(stack))) {
            this.cast(stack, event);
        }
    }

    public String getEvent(ItemStack stack) {
        return "psi.event.none";
    }

    public String getTrueEvent(ItemStack stack) {
        return stack.func_196082_o().func_74779_i("PsiEvent").isEmpty() ? this.getEvent(stack) : stack.func_196082_o().func_74779_i("PsiEvent");
    }

    public int getCastCooldown(ItemStack stack) {
        return 5;
    }

    public float getCastVolume() {
        return 0.025f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        TooltipHelper.tooltipIfShift(tooltip, () -> {
            ITextComponent componentName = ISocketable.getSocketedItemName(stack, "psimisc.none");
            tooltip.add((ITextComponent)new TranslationTextComponent("psimisc.spell_selected", new Object[]{componentName}));
            tooltip.add((ITextComponent)new TranslationTextComponent(this.getTrueEvent(stack)));
        });
    }

    public boolean isRepairable(ItemStack stack) {
        return super.isRepairable(stack);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "psi:textures/model/psimetal_exosuit.png";
    }

    public boolean hasColor(@Nonnull ItemStack stack) {
        return true;
    }

    public int getColor(@Nonnull ItemStack stack) {
        return 1295871;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return (A)((BipedModel)this.model.func_179281_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<?> provideArmorModelForSlot(EquipmentSlotType slot) {
        return new ModelPsimetalExosuit(slot);
    }

    public static class ArmorSocketable
    extends ToolSocketable {
        public ArmorSocketable(ItemStack tool, int slots) {
            super(tool, slots);
        }

        @Override
        public void setSelectedSlot(int slot) {
            super.setSelectedSlot(slot);
            this.tool.func_196082_o().func_74768_a(ItemPsimetalArmor.TAG_TIMES_CAST, 0);
        }

        @Override
        public void setBulletInSocket(int slot, ItemStack bullet) {
            super.setBulletInSocket(slot, bullet);
            this.tool.func_196082_o().func_74768_a(ItemPsimetalArmor.TAG_TIMES_CAST, 0);
        }
    }
}

