/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.ItemSpellDrive;

public class ItemSpellBullet
extends Item {
    public static final String TAG_SPELL = "spell";

    public ItemSpellBullet(Item.Properties properties) {
        super(properties.func_200917_a(16));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new SpellAcceptor(stack);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        if (ISpellAcceptor.hasSpell(stack)) {
            CompoundNBT cmp = stack.func_196082_o().func_74775_l(TAG_SPELL);
            String name = cmp.func_74779_i("spellName");
            if (name.isEmpty()) {
                return super.func_200295_i(stack);
            }
            return new StringTextComponent(name);
        }
        return super.func_200295_i(stack);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Rarity func_77613_e(ItemStack stack) {
        return ISpellAcceptor.hasSpell(stack) ? Rarity.RARE : Rarity.COMMON;
    }

    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        TooltipHelper.tooltipIfShift(tooltip, () -> {
            tooltip.add((ITextComponent)new TranslationTextComponent("psimisc.bullet_type", new Object[]{new TranslationTextComponent("psi.bullet_type_" + this.getBulletType())}));
            tooltip.add((ITextComponent)new TranslationTextComponent("psimisc.bullet_cost", new Object[]{(int)(ISpellAcceptor.acceptor(stack).getCostModifier() * 100.0)}));
        });
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (ItemSpellDrive.getSpell(itemStackIn) != null && playerIn.func_225608_bj_()) {
            if (!worldIn.field_72995_K) {
                worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), PsiSoundHandler.compileError, SoundCategory.PLAYERS, 0.5f, 1.0f);
            } else {
                playerIn.func_184609_a(hand);
            }
            ItemSpellDrive.setSpell(itemStackIn, null);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemStackIn);
    }

    public String getBulletType() {
        return "basic";
    }

    public void castSpell(ItemStack stack, SpellContext context) {
        context.cspell.safeExecute(context);
    }

    public double getCostModifier(ItemStack stack) {
        return 1.0;
    }

    public boolean isCADOnlyContainer(ItemStack stack) {
        return false;
    }

    protected static class SpellAcceptor
    implements ICapabilityProvider,
    ISpellAcceptor {
        protected final ItemStack stack;
        private final LazyOptional<ISpellAcceptor> capOptional;

        protected SpellAcceptor(ItemStack stack) {
            this.stack = stack;
            this.capOptional = LazyOptional.of(() -> this);
        }

        private ItemSpellBullet bulletItem() {
            return (ItemSpellBullet)this.stack.func_77973_b();
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PsiAPI.SPELL_ACCEPTOR_CAPABILITY.orEmpty(cap, this.capOptional);
        }

        @Override
        public void setSpell(PlayerEntity player, Spell spell) {
            if (this.stack.func_190916_E() == 1) {
                ItemSpellDrive.setSpell(this.stack, spell);
                return;
            }
            this.stack.func_190918_g(1);
            ItemStack newStack = this.stack.func_77946_l();
            newStack.func_190920_e(1);
            ItemSpellDrive.setSpell(newStack, spell);
            if (!player.func_191521_c(newStack)) {
                player.func_71019_a(newStack, false);
            }
        }

        @Override
        public Spell getSpell() {
            return ItemSpellDrive.getSpell(this.stack);
        }

        @Override
        public boolean containsSpell() {
            return this.stack.func_196082_o().func_74767_n("has_spell");
        }

        @Override
        public void castSpell(SpellContext context) {
            this.bulletItem().castSpell(this.stack, context);
        }

        @Override
        public double getCostModifier() {
            return this.bulletItem().getCostModifier(this.stack);
        }

        @Override
        public boolean castableFromSocket() {
            return true;
        }

        @Override
        public boolean isCADOnlyContainer() {
            return this.bulletItem().isCADOnlyContainer(this.stack);
        }

        @Override
        public boolean requiresSneakForSpellSet() {
            return false;
        }
    }
}

