/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.entity;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.common.Psi;
import vazkii.psi.common.entity.EntitySpellGrenade;

public class EntitySpellProjectile
extends ThrowableEntity {
    @ObjectHolder(value="psi:spell_projectile")
    public static EntityType<EntitySpellProjectile> TYPE;
    private static final String TAG_COLORIZER = "colorizer";
    private static final String TAG_BULLET = "bullet";
    private static final String TAG_TIME_ALIVE = "timeAlive";
    private static final String TAG_LAST_MOTION_X = "lastMotionX";
    private static final String TAG_LAST_MOTION_Y = "lastMotionY";
    private static final String TAG_LAST_MOTION_Z = "lastMotionZ";
    private static final DataParameter<ItemStack> COLORIZER_DATA;
    private static final DataParameter<ItemStack> BULLET_DATA;
    private static final DataParameter<Optional<UUID>> CASTER_UUID;
    protected static final DataParameter<Optional<UUID>> ATTACKTARGET_UUID;
    public SpellContext context;
    public int timeAlive;

    public EntitySpellProjectile(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected EntitySpellProjectile(EntityType<? extends ThrowableEntity> type, World world, LivingEntity thrower) {
        super(type, thrower, world);
        this.func_212361_a((Entity)thrower);
        this.func_70101_b(thrower.field_70177_z + 180.0f, -thrower.field_70125_A);
        float f = 1.5f;
        double mx = (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f) / 2.0;
        double mz = (double)(-(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f)) / 2.0;
        double my = (double)(MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f) / 2.0;
        this.func_213293_j(mx, my, mz);
    }

    public EntitySpellProjectile(World world, LivingEntity thrower) {
        this(TYPE, world, thrower);
    }

    public EntitySpellProjectile setInfo(PlayerEntity player, ItemStack colorizer, ItemStack bullet) {
        this.field_70180_af.func_187227_b(COLORIZER_DATA, (Object)colorizer);
        this.field_70180_af.func_187227_b(BULLET_DATA, (Object)bullet);
        this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(player.func_110124_au()));
        this.field_70180_af.func_187227_b(ATTACKTARGET_UUID, Optional.empty());
        return this;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLORIZER_DATA, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(BULLET_DATA, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(CASTER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(ATTACKTARGET_UUID, Optional.empty());
    }

    public void func_213281_b(CompoundNBT tagCompound) {
        super.func_213281_b(tagCompound);
        CompoundNBT colorizerCmp = new CompoundNBT();
        ItemStack colorizer = (ItemStack)this.field_70180_af.func_187225_a(COLORIZER_DATA);
        if (!colorizer.func_190926_b()) {
            colorizerCmp = colorizer.func_77955_b(colorizerCmp);
        }
        tagCompound.func_218657_a(TAG_COLORIZER, (INBT)colorizerCmp);
        CompoundNBT bulletCmp = new CompoundNBT();
        ItemStack bullet = (ItemStack)this.field_70180_af.func_187225_a(BULLET_DATA);
        if (!bullet.func_190926_b()) {
            bulletCmp = bullet.func_77955_b(bulletCmp);
        }
        tagCompound.func_218657_a(TAG_BULLET, (INBT)bulletCmp);
        tagCompound.func_74768_a(TAG_TIME_ALIVE, this.timeAlive);
        tagCompound.func_74780_a(TAG_LAST_MOTION_X, this.func_213322_ci().func_82615_a());
        tagCompound.func_74780_a(TAG_LAST_MOTION_Y, this.func_213322_ci().func_82617_b());
        tagCompound.func_74780_a(TAG_LAST_MOTION_Z, this.func_213322_ci().func_82616_c());
    }

    public void func_70037_a(CompoundNBT tagCompound) {
        super.func_70037_a(tagCompound);
        CompoundNBT colorizerCmp = tagCompound.func_74775_l(TAG_COLORIZER);
        ItemStack colorizer = ItemStack.func_199557_a((CompoundNBT)colorizerCmp);
        this.field_70180_af.func_187227_b(COLORIZER_DATA, (Object)colorizer);
        CompoundNBT bulletCmp = tagCompound.func_74775_l(TAG_BULLET);
        ItemStack bullet = ItemStack.func_199557_a((CompoundNBT)bulletCmp);
        this.field_70180_af.func_187227_b(BULLET_DATA, (Object)bullet);
        Entity thrower = this.func_234616_v_();
        if (thrower instanceof PlayerEntity) {
            this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(thrower.func_110124_au()));
        }
        this.timeAlive = tagCompound.func_74762_e(TAG_TIME_ALIVE);
        double lastMotionX = tagCompound.func_74769_h(TAG_LAST_MOTION_X);
        double lastMotionY = tagCompound.func_74769_h(TAG_LAST_MOTION_Y);
        double lastMotionZ = tagCompound.func_74769_h(TAG_LAST_MOTION_Z);
        this.func_213293_j(lastMotionX, lastMotionY, lastMotionZ);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int timeAlive = this.field_70173_aa;
        if (timeAlive > this.getLiveTime()) {
            this.func_70106_y();
        }
        ItemStack colorizer = (ItemStack)this.field_70180_af.func_187225_a(COLORIZER_DATA);
        int colorVal = Psi.proxy.getColorForColorizer(colorizer);
        float r = (float)PsiRenderHelper.r(colorVal) / 255.0f;
        float g = (float)PsiRenderHelper.g(colorVal) / 255.0f;
        float b = (float)PsiRenderHelper.b(colorVal) / 255.0f;
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        Vector3 lookOrig = new Vector3(this.func_213322_ci()).normalize();
        for (int i = 0; i < this.getParticleCount(); ++i) {
            Vector3 look = lookOrig.copy();
            double spread = 0.6;
            double dist = 0.15;
            if (this instanceof EntitySpellGrenade) {
                look.y += 1.0;
                dist = 0.05;
            }
            look.x += (Math.random() - 0.5) * spread;
            look.y += (Math.random() - 0.5) * spread;
            look.z += (Math.random() - 0.5) * spread;
            look.normalize().multiply(dist);
            if (!this.field_70170_p.func_201670_d()) continue;
            Psi.proxy.sparkleFX(x, y, z, r, g, b, (float)look.x, (float)look.y, (float)look.z, 1.2f, 12);
        }
    }

    public int getLiveTime() {
        return 600;
    }

    public int getParticleCount() {
        return 5;
    }

    protected void func_70227_a(@Nonnull RayTraceResult pos) {
        if (pos instanceof EntityRayTraceResult && ((EntityRayTraceResult)pos).func_216348_a() instanceof LivingEntity) {
            this.cast(context -> {
                if (context != null) {
                    context.attackedEntity = (LivingEntity)((EntityRayTraceResult)pos).func_216348_a();
                }
            });
        } else {
            this.cast();
        }
    }

    public void cast() {
        this.cast(null);
    }

    public void cast(Consumer<SpellContext> callback) {
        Spell spell;
        ItemStack spellContainer;
        Entity thrower = this.func_234616_v_();
        boolean canCast = false;
        if (thrower instanceof PlayerEntity && !(spellContainer = (ItemStack)this.field_70180_af.func_187225_a(BULLET_DATA)).func_190926_b() && ISpellAcceptor.isContainer(spellContainer) && (spell = ISpellAcceptor.acceptor(spellContainer).getSpell()) != null) {
            canCast = true;
            if (this.context == null) {
                this.context = new SpellContext().setPlayer((PlayerEntity)thrower).setFocalPoint((Entity)this).setSpell(spell);
            }
            this.context.setFocalPoint((Entity)this);
        }
        if (callback != null) {
            callback.accept(this.context);
        }
        if (canCast && this.context != null) {
            this.context.cspell.safeExecute(this.context);
        }
        this.func_70106_y();
    }

    public Entity func_234616_v_() {
        Entity superThrower = super.func_234616_v_();
        if (superThrower != null) {
            return superThrower;
        }
        return ((Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).map(u -> this.func_130014_f_().func_217371_b(u)).orElse(null);
    }

    public LivingEntity getAttackTarget() {
        double radiusVal = 32.0;
        Vector3 positionVal = Vector3.fromVec3d(this.func_213303_ch());
        AxisAlignedBB axis = new AxisAlignedBB(positionVal.x - radiusVal, positionVal.y - radiusVal, positionVal.z - radiusVal, positionVal.x + radiusVal, positionVal.y + radiusVal, positionVal.z + radiusVal);
        return ((Optional)this.field_70180_af.func_187225_a(ATTACKTARGET_UUID)).map(u -> {
            List a = this.func_130014_f_().func_175647_a(LivingEntity.class, axis, e -> e.func_110124_au().equals(u));
            if (a.size() > 0) {
                return (LivingEntity)a.get(0);
            }
            return null;
        }).orElse(null);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public boolean func_145773_az() {
        return true;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static {
        COLORIZER_DATA = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (IDataSerializer)DataSerializers.field_187196_f);
        BULLET_DATA = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (IDataSerializer)DataSerializers.field_187196_f);
        CASTER_UUID = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (IDataSerializer)DataSerializers.field_187203_m);
        ATTACKTARGET_UUID = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (IDataSerializer)DataSerializers.field_187203_m);
    }
}

