/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.RegenPsiEvent;
import vazkii.psi.api.exosuit.IPsiEventArmor;
import vazkii.psi.api.exosuit.PsiArmorEvent;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.PieceExecutedEvent;
import vazkii.psi.api.spell.PieceGroupAdvancementComplete;
import vazkii.psi.api.spell.PieceKnowledgeEvent;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.core.handler.ClientTickHandler;
import vazkii.psi.client.render.entity.RenderSpellCircle;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.LoopcastTrackingHandler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageDataSync;
import vazkii.psi.common.network.message.MessageDeductPsi;
import vazkii.psi.common.network.message.MessageTriggerJumpSpell;

public class PlayerDataHandler {
    private static final WeakHashMap<PlayerEntity, PlayerData> remotePlayerData = new WeakHashMap();
    private static final WeakHashMap<PlayerEntity, PlayerData> playerData = new WeakHashMap();
    public static final Set<SpellContext> delayedContexts = new HashSet<SpellContext>();
    private static final String DATA_TAG = "PsiData";
    public static final DamageSource damageSourceOverload = new DamageSource("psi-overload").func_76348_h().func_82726_p();

    @Nonnull
    public static PlayerData get(PlayerEntity player) {
        if (player == null) {
            return new PlayerData();
        }
        WeakHashMap<PlayerEntity, PlayerData> dataMap = player.field_70170_p.field_72995_K ? remotePlayerData : playerData;
        PlayerData data = dataMap.computeIfAbsent(player, PlayerData::new);
        if (data.playerWR != null && data.playerWR.get() != player) {
            CompoundNBT cmp = new CompoundNBT();
            data.writeToNBT(cmp);
            dataMap.remove(player);
            data = PlayerDataHandler.get(player);
            data.readFromNBT(cmp);
        }
        return data;
    }

    public static CompoundNBT getDataCompoundForPlayer(PlayerEntity player) {
        CompoundNBT persistentData;
        CompoundNBT forgeData = player.getPersistentData();
        if (!forgeData.func_74764_b("PlayerPersisted")) {
            forgeData.func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
        }
        if (!(persistentData = forgeData.func_74775_l("PlayerPersisted")).func_74764_b(DATA_TAG)) {
            persistentData.func_218657_a(DATA_TAG, (INBT)new CompoundNBT());
        }
        return persistentData.func_74775_l(DATA_TAG);
    }

    public static class PlayerData
    implements IPlayerData {
        private static final String TAG_AVAILABLE_PSI = "availablePsi";
        private static final String TAG_REGEN_CD = "regenCd";
        private static final String TAG_OVERFLOWED = "overflowed";
        private static final String TAG_EIDOS_ANCHOR_X = "eidosAnchorX";
        private static final String TAG_EIDOS_ANCHOR_Y = "eidosAnchorY";
        private static final String TAG_EIDOS_ANCHOR_Z = "eidosAnchorZ";
        private static final String TAG_EIDOS_ANCHOR_PITCH = "eidosAnchorPitch";
        private static final String TAG_EIDOS_ANCHOR_YAW = "eidosAnchorYaw";
        private static final String TAG_EIDOS_ANCHOR_TIME = "eidosAnchorTime";
        private static final String TAG_CUSTOM_DATA = "customData";
        public int totalPsi = 5000;
        public int regen = 25;
        public int availablePsi;
        public int lastAvailablePsi;
        public int regenCooldown;
        public boolean loopcasting = false;
        public Hand loopcastHand = null;
        public ItemStack lastTickLoopcastStack;
        public int loopcastTime = 1;
        public int loopcastAmount = 0;
        public int loopcastFadeTime = 0;
        public boolean overflowed = false;
        public final Stack<Vector3> eidosChangelog = new Stack();
        public Vector3 eidosAnchor = new Vector3(0.0, 0.0, 0.0);
        public double eidosAnchorPitch;
        public double eidosAnchorYaw;
        public boolean isAnchored;
        public boolean isReverting;
        public int eidosAnchorTime;
        public int postAnchorRecallTime;
        public int eidosReversionTime;
        public DimensionType lastDimension;
        private boolean lowLight;
        private boolean underwater;
        private boolean lowHp;
        public boolean deductTick;
        public final List<Deduction> deductions = new ArrayList<Deduction>();
        public final WeakReference<PlayerEntity> playerWR;
        private final boolean client;
        private CompoundNBT customData;

        private PlayerData() {
            this.playerWR = new WeakReference<Object>(null);
            this.client = true;
        }

        public PlayerData(PlayerEntity player) {
            this.playerWR = new WeakReference<PlayerEntity>(player);
            this.client = player.func_130014_f_().field_72995_K;
            this.load();
        }

        /*
         * Unable to fully structure code
         */
        public void tick() {
            block46: {
                block44: {
                    block47: {
                        block49: {
                            block48: {
                                block45: {
                                    player = (PlayerEntity)this.playerWR.get();
                                    if (player == null) {
                                        return;
                                    }
                                    dimension = player.func_130014_f_().func_230315_m_();
                                    if (this.deductTick) {
                                        this.deductTick = false;
                                    } else {
                                        this.lastAvailablePsi = this.availablePsi;
                                    }
                                    max = this.getTotalPsi();
                                    if (this.availablePsi > max) {
                                        this.availablePsi = max;
                                    }
                                    if (!(cadStack = this.getCAD()).func_190926_b()) {
                                        cad = (ICAD)cadStack.func_77973_b();
                                        overflow = cad.getStatValue(cadStack, EnumCADStat.OVERFLOW);
                                        if (overflow == -1) {
                                            this.availablePsi = max;
                                        } else {
                                            this.applyRegen(player, max, cadStack);
                                        }
                                    } else {
                                        this.applyRegen(player, max, cadStack);
                                    }
                                    color = 1295871;
                                    if (!cadStack.func_190926_b()) {
                                        color = Psi.proxy.getColorForCAD(cadStack);
                                    }
                                    r = (float)PsiRenderHelper.r(color) / 255.0f;
                                    g = (float)PsiRenderHelper.g(color) / 255.0f;
                                    b = (float)PsiRenderHelper.b(color) / 255.0f;
                                    if (this.overflowed) {
                                        this.stopLoopcast();
                                    }
                                    if (!this.loopcasting || this.loopcastHand == null) break block44;
                                    stackInHand = player.func_184586_b(this.loopcastHand);
                                    if (!stackInHand.func_190926_b() && ISocketable.isSocketable(stackInHand) && ISocketable.socketable(stackInHand).canLoopcast()) break block45;
                                    this.stopLoopcast();
                                    break block46;
                                }
                                if (this.lastTickLoopcastStack == null) break block47;
                                if (ItemStack.func_179545_c((ItemStack)this.lastTickLoopcastStack, (ItemStack)stackInHand) && ISocketable.isSocketable(this.lastTickLoopcastStack)) break block48;
                                this.stopLoopcast();
                                break block46;
                            }
                            lastTickItem = ISocketable.socketable(this.lastTickLoopcastStack);
                            thisTickItem = ISocketable.socketable(stackInHand);
                            lastSlot = lastTickItem.getSelectedSlot();
                            if (lastSlot == (thisSlot = thisTickItem.getSelectedSlot())) break block49;
                            this.stopLoopcast();
                            break block46;
                        }
                        lastTick = lastTickItem.getBulletInSocket(lastSlot);
                        if (ItemStack.func_77989_b((ItemStack)lastTick, (ItemStack)(thisTick = thisTickItem.getBulletInSocket(thisSlot)))) break block47;
                        this.stopLoopcast();
                        break block46;
                    }
                    this.lastTickLoopcastStack = stackInHand.func_77946_l();
                    socketable = ISocketable.socketable(stackInHand);
                    for (i = 0; i < 5; ++i) {
                        x = player.func_226277_ct_() + (Math.random() - 0.5) * 2.1 * (double)player.func_213311_cf();
                        y = player.func_226278_cu_() - player.func_70033_W();
                        z = player.func_226281_cx_() + (Math.random() - 0.5) * 2.1 * (double)player.func_213311_cf();
                        grav = -0.15f - (float)Math.random() * 0.03f;
                        Psi.proxy.sparkleFX(x, y, z, r, g, b, grav, 0.25f, 15);
                    }
                    if (this.loopcastTime <= 0 || this.loopcastTime % 5 != 0) ** GOTO lbl79
                    bullet = socketable.getSelectedBullet();
                    if (bullet.func_190926_b() || !ISpellAcceptor.hasSpell(bullet)) {
                        this.stopLoopcast();
                    } else {
                        spellContainer = ISpellAcceptor.acceptor(bullet);
                        spell = spellContainer.getSpell();
                        context = new SpellContext().setPlayer(player).setSpell(spell).setLoopcastIndex(this.loopcastAmount + 1);
                        if (context.isValid() && context.cspell.metadata.evaluateAgainst(cadStack)) {
                            cost = ItemCAD.getRealCost(cadStack, bullet, context.cspell.metadata.stats.get((Object)EnumSpellStat.COST));
                            if (cost > 0 || cost == -1) {
                                if (cost != -1) {
                                    this.deductPsi(cost, 0, true);
                                }
                                if (!player.func_130014_f_().field_72995_K && this.loopcastTime % 10 == 0) {
                                    player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), PsiSoundHandler.loopcast, SoundCategory.PLAYERS, 0.1f, (float)(0.15 + Math.random() * 0.85));
                                }
                            }
                            if (!player.func_130014_f_().field_72995_K) {
                                context.cspell.safeExecute(context);
                            }
                            ++this.loopcastAmount;
                        }
lbl79:
                        // 4 sources

                        ++this.loopcastTime;
                    }
                    break block46;
                }
                if (this.loopcastFadeTime > 0) {
                    --this.loopcastFadeTime;
                }
            }
            if (!player.func_70089_S() || dimension != this.lastDimension) {
                this.eidosAnchorTime = 0;
                this.eidosReversionTime = 0;
                this.eidosChangelog.clear();
                this.isAnchored = false;
                this.isReverting = false;
            }
            if (this.eidosAnchorTime > 0) {
                if (this.eidosAnchorTime == 1) {
                    if (player instanceof ServerPlayerEntity) {
                        pmp = (ServerPlayerEntity)player;
                        pmp.field_71135_a.func_147364_a(this.eidosAnchor.x, this.eidosAnchor.y, this.eidosAnchor.z, (float)this.eidosAnchorYaw, (float)this.eidosAnchorPitch);
                        for (riding = player.func_184187_bx(); riding != null; riding = riding.func_184187_bx()) {
                            riding.func_70107_b(this.eidosAnchor.x, this.eidosAnchor.y, this.eidosAnchor.z);
                        }
                    }
                    this.postAnchorRecallTime = 0;
                }
                --this.eidosAnchorTime;
            } else if (this.postAnchorRecallTime < 5) {
                --this.postAnchorRecallTime;
                this.isAnchored = false;
            }
            if (this.eidosReversionTime > 0) {
                if (this.eidosChangelog.isEmpty()) {
                    this.eidosReversionTime = 0;
                    this.isReverting = false;
                } else {
                    this.eidosChangelog.pop();
                    if (this.eidosChangelog.isEmpty()) {
                        this.eidosReversionTime = 0;
                        this.isReverting = false;
                    } else {
                        vec = this.eidosChangelog.pop();
                        if (player instanceof ServerPlayerEntity) {
                            pmp = (ServerPlayerEntity)player;
                            pmp.field_71135_a.func_175089_a(vec.x, vec.y, vec.z, 0.0f, 0.0f, (Set)ImmutableSet.of((Object)SPlayerPositionLookPacket.Flags.X_ROT, (Object)SPlayerPositionLookPacket.Flags.Y_ROT));
                            pmp.field_71135_a.func_184342_d();
                        } else {
                            player.func_70107_b(vec.x, vec.y, vec.z);
                        }
                        for (riding = player.func_184187_bx(); riding != null; riding = riding.func_184187_bx()) {
                            riding.func_70107_b(vec.x, vec.y, vec.z);
                        }
                        if (player.field_70170_p.field_72995_K) {
                            for (i = 0; i < 5; ++i) {
                                spread = 0.6;
                                x = player.func_226277_ct_() + (Math.random() - 0.5) * spread;
                                y = player.func_226278_cu_() + (Math.random() - 0.5) * spread;
                                z = player.func_226281_cx_() + (Math.random() - 0.5) * spread;
                                Psi.proxy.sparkleFX(x, y, z, r, g, b, 0.0f, 0.0f, 0.0f, 1.2f, 12);
                            }
                        }
                        player.func_213293_j(0.0, 0.0, 0.0);
                        player.field_70143_R = 0.0f;
                    }
                }
                --this.eidosReversionTime;
                if (this.eidosReversionTime == 0 || player.func_225608_bj_()) {
                    this.eidosChangelog.clear();
                    this.isReverting = false;
                }
            } else {
                if (this.eidosChangelog.size() > 600) {
                    this.eidosChangelog.remove(0);
                }
                this.eidosChangelog.push(Vector3.fromEntity((Entity)player));
            }
            pos = player.func_233580_cy_();
            light = player.func_130014_f_().func_225524_e_().func_227470_b_(pos, 0);
            v0 = lowLight = light <= 7;
            if (!this.lowLight && lowLight) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.low_light"));
            }
            this.lowLight = lowLight;
            underwater = player.func_70090_H();
            if (!this.underwater && underwater) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.underwater"));
            }
            this.underwater = underwater;
            v1 = lowHp = player.func_110143_aJ() <= 6.0f;
            if (!this.lowHp && lowHp) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.low_hp"));
            }
            this.lowHp = lowHp;
            remove = new ArrayList<Deduction>();
            for (Deduction d : this.deductions) {
                if (d.invalid) {
                    remove.add(d);
                    continue;
                }
                d.tick();
            }
            this.deductions.removeAll(remove);
            this.lastDimension = dimension;
        }

        private void applyRegen(PlayerEntity player, int max, ItemStack cadStack) {
            RegenPsiEvent event = new RegenPsiEvent(player, this, cadStack);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (!cadStack.func_190926_b()) {
                    ICAD cad = (ICAD)cadStack.func_77973_b();
                    cad.regenPsi(cadStack, event.getCadRegen());
                }
                boolean anyChange = false;
                if (this.availablePsi != max && event.getPlayerRegen() > 0) {
                    anyChange = true;
                }
                this.availablePsi = Math.min(max, this.availablePsi + event.getPlayerRegen());
                if (this.overflowed && event.willHealOverflow()) {
                    anyChange = true;
                    this.overflowed = false;
                }
                if (this.regenCooldown != event.getRegenCooldown()) {
                    anyChange = true;
                }
                this.regenCooldown = event.getRegenCooldown();
                if (anyChange) {
                    this.save();
                }
            }
        }

        public void stopLoopcast() {
            if (this.loopcasting) {
                this.loopcastFadeTime = 5;
            }
            this.loopcasting = false;
            this.lastTickLoopcastStack = null;
            this.loopcastHand = null;
            this.loopcastTime = 1;
            this.loopcastAmount = 0;
            PlayerEntity player = (PlayerEntity)this.playerWR.get();
            if (player instanceof ServerPlayerEntity) {
                LoopcastTrackingHandler.syncForTrackersAndSelf((ServerPlayerEntity)player);
            }
        }

        public int calculateDamageDeduction(float amount) {
            return (int)((double)this.getTotalPsi() * 0.02 * (double)amount);
        }

        public void damage(float amount) {
            int psi = this.calculateDamageDeduction(amount);
            if (psi > 0 && this.availablePsi > 0) {
                psi = Math.min(psi, this.availablePsi);
                this.deductPsi(psi, 20, true, true);
            }
        }

        public ItemStack getCAD() {
            return PsiAPI.getPlayerCAD((PlayerEntity)this.playerWR.get());
        }

        public void deductPsi(int psi, int cd, boolean sync) {
            this.deductPsi(psi, cd, sync, false);
        }

        @Override
        public void deductPsi(int psi, int cd, boolean sync, boolean shatter) {
            ICAD cad;
            int storedPsi;
            int currentPsi = this.availablePsi;
            PlayerEntity player = (PlayerEntity)this.playerWR.get();
            if (player == null) {
                return;
            }
            ItemStack cadStack = this.getCAD();
            if (!cadStack.func_190926_b() && (storedPsi = (cad = (ICAD)cadStack.func_77973_b()).getStoredPsi(cadStack)) == -1) {
                return;
            }
            this.availablePsi -= psi;
            if (this.regenCooldown < cd) {
                this.regenCooldown = cd;
            }
            if (this.availablePsi < 0) {
                int overflow = -this.availablePsi;
                this.availablePsi = 0;
                if (!cadStack.func_190926_b()) {
                    ICAD cad2 = (ICAD)cadStack.func_77973_b();
                    overflow = cad2.consumePsi(cadStack, overflow);
                }
                if (!shatter && overflow > 0) {
                    float dmg = (float)overflow / (float)(this.loopcasting ? 50 : 125);
                    if (!this.client) {
                        player.func_70097_a(damageSourceOverload, dmg);
                    }
                    this.overflowed = true;
                }
            }
            if (sync && player instanceof ServerPlayerEntity) {
                MessageDeductPsi message = new MessageDeductPsi(currentPsi, this.availablePsi, this.regenCooldown, shatter);
                MessageRegister.sendToPlayer(message, player);
            }
            this.save();
        }

        public void addDeduction(int current, int deduct, boolean shatter) {
            if (deduct > current) {
                deduct = current;
            }
            if (deduct < 0) {
                deduct = 0;
            }
            if (deduct == 0) {
                return;
            }
            this.deductions.add(new Deduction(current, deduct, 20, shatter));
        }

        @Override
        public int getAvailablePsi() {
            return this.availablePsi;
        }

        @Override
        public int getLastAvailablePsi() {
            return this.lastAvailablePsi;
        }

        @Override
        public int getTotalPsi() {
            return this.totalPsi;
        }

        @Override
        public int getRegenPerTick() {
            return this.regen;
        }

        @Override
        public boolean isOverflowed() {
            return this.overflowed;
        }

        @Override
        public int getRegenCooldown() {
            return this.regenCooldown;
        }

        public boolean hasAdvancement(ResourceLocation group) {
            PlayerEntity player = (PlayerEntity)this.playerWR.get();
            return Psi.proxy.hasAdvancement(group, player);
        }

        @Override
        public boolean isPieceGroupUnlocked(ResourceLocation group, @Nullable ResourceLocation name) {
            PlayerEntity player = (PlayerEntity)this.playerWR.get();
            if (player == null) {
                return false;
            }
            if (player.func_184812_l_()) {
                return true;
            }
            boolean hasAdvancement = this.hasAdvancement(group);
            PieceKnowledgeEvent event = new PieceKnowledgeEvent(group, name, player, this, hasAdvancement);
            MinecraftForge.EVENT_BUS.post((Event)event);
            switch (event.getResult()) {
                case DENY: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void unlockPieceGroup(ResourceLocation resourceLocation) {
            ServerPlayerEntity serverPlayer;
            Advancement advancement;
            PlayerEntity player = (PlayerEntity)this.playerWR.get();
            if (player instanceof ServerPlayerEntity && (advancement = (serverPlayer = (ServerPlayerEntity)player).func_184102_h().func_191949_aK().func_192778_a(resourceLocation)) != null && !serverPlayer.func_192039_O().func_192747_a(advancement).func_192105_a()) {
                for (String s : serverPlayer.func_192039_O().func_192747_a(advancement).func_192107_d()) {
                    serverPlayer.func_192039_O().func_192747_a(advancement).func_192109_a(s);
                }
            }
        }

        @Override
        public void markPieceExecuted(SpellPiece piece) {
            PieceExecutedEvent event = new PieceExecutedEvent(piece, (PlayerEntity)this.playerWR.get());
            MinecraftForge.EVENT_BUS.post((Event)event);
            ResourceLocation advancement = PsiAPI.getGroupForPiece(piece.getClass());
            if (advancement != null && PsiAPI.getMainPieceForGroup(advancement) == piece.getClass() && !this.hasAdvancement(advancement)) {
                MinecraftForge.EVENT_BUS.post((Event)new PieceGroupAdvancementComplete(piece, (PlayerEntity)this.playerWR.get(), advancement));
            }
        }

        @Override
        public CompoundNBT getCustomData() {
            if (this.customData == null) {
                this.customData = new CompoundNBT();
                return this.customData;
            }
            return this.customData;
        }

        @Override
        public void save() {
            PlayerEntity player;
            if (!this.client && (player = (PlayerEntity)this.playerWR.get()) != null) {
                CompoundNBT cmp = PlayerDataHandler.getDataCompoundForPlayer(player);
                this.writeToNBT(cmp);
            }
        }

        public void writeToNBT(CompoundNBT cmp) {
            cmp.func_74768_a(TAG_AVAILABLE_PSI, this.availablePsi);
            cmp.func_74768_a(TAG_REGEN_CD, this.regenCooldown);
            cmp.func_74757_a(TAG_OVERFLOWED, this.overflowed);
            cmp.func_74780_a(TAG_EIDOS_ANCHOR_X, this.eidosAnchor.x);
            cmp.func_74780_a(TAG_EIDOS_ANCHOR_Y, this.eidosAnchor.y);
            cmp.func_74780_a(TAG_EIDOS_ANCHOR_Z, this.eidosAnchor.z);
            cmp.func_74780_a(TAG_EIDOS_ANCHOR_PITCH, this.eidosAnchorPitch);
            cmp.func_74780_a(TAG_EIDOS_ANCHOR_YAW, this.eidosAnchorYaw);
            cmp.func_74768_a(TAG_EIDOS_ANCHOR_TIME, this.eidosAnchorTime);
            if (this.customData != null) {
                cmp.func_218657_a(TAG_CUSTOM_DATA, (INBT)this.customData);
            }
        }

        public void load() {
            PlayerEntity player;
            if (!this.client && (player = (PlayerEntity)this.playerWR.get()) != null) {
                CompoundNBT cmp = PlayerDataHandler.getDataCompoundForPlayer(player);
                this.readFromNBT(cmp);
            }
        }

        public void readFromNBT(CompoundNBT cmp) {
            this.availablePsi = cmp.func_74762_e(TAG_AVAILABLE_PSI);
            this.regenCooldown = cmp.func_74762_e(TAG_REGEN_CD);
            this.overflowed = cmp.func_74767_n(TAG_OVERFLOWED);
            double x = cmp.func_74769_h(TAG_EIDOS_ANCHOR_X);
            double y = cmp.func_74769_h(TAG_EIDOS_ANCHOR_X);
            double z = cmp.func_74769_h(TAG_EIDOS_ANCHOR_X);
            this.eidosAnchor.set(x, y, z);
            this.eidosAnchorPitch = cmp.func_74769_h(TAG_EIDOS_ANCHOR_PITCH);
            this.eidosAnchorYaw = cmp.func_74769_h(TAG_EIDOS_ANCHOR_YAW);
            this.eidosAnchorTime = cmp.func_74762_e(TAG_EIDOS_ANCHOR_TIME);
            this.customData = cmp.func_74775_l(TAG_CUSTOM_DATA);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(PlayerEntity player, float partTicks, MatrixStack ms) {
            float mul;
            EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            double x = player.field_70142_S + (player.func_226277_ct_() - player.field_70142_S) * (double)partTicks - renderManager.field_217783_c.func_216785_c().field_72450_a;
            double y = player.field_70137_T + (player.func_226278_cu_() - player.field_70137_T) * (double)partTicks - renderManager.field_217783_c.func_216785_c().field_72448_b;
            double z = player.field_70136_U + (player.func_226281_cx_() - player.field_70136_U) * (double)partTicks - renderManager.field_217783_c.func_216785_c().field_72449_c;
            float scale = 0.75f;
            if (this.loopcasting) {
                mul = Math.min(5.0f, (float)this.loopcastTime + partTicks) / 5.0f;
                scale *= mul;
            } else if (this.loopcastFadeTime > 0) {
                mul = Math.min(5.0f, (float)this.loopcastFadeTime - partTicks) / 5.0f;
                scale *= mul;
            } else {
                return;
            }
            int color = 1295871;
            ItemStack cad = PsiAPI.getPlayerCAD((PlayerEntity)this.playerWR.get());
            if (!cad.func_190926_b() && cad.func_77973_b() instanceof ICAD) {
                ICAD icad = (ICAD)cad.func_77973_b();
                color = icad.getSpellColor(cad);
            }
            ms.func_227860_a_();
            ms.func_227861_a_(x, y + 0.15, z);
            IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            RenderSpellCircle.renderSpellCircle((float)ClientTickHandler.ticksInGame + partTicks, scale, 1.0f, 0.0f, -1.0f, 0.0f, color, ms, (IRenderTypeBuffer)buffers);
            buffers.func_228461_a_();
            ms.func_227865_b_();
        }

        public static class Deduction {
            public final int current;
            public final int deduct;
            public final int cd;
            public final boolean shatter;
            public int elapsed;
            public boolean invalid;

            public Deduction(int current, int deduct, int cd, boolean shatter) {
                this.current = current;
                this.deduct = deduct;
                this.cd = cd;
                this.shatter = shatter;
            }

            public void tick() {
                ++this.elapsed;
                if (this.elapsed >= this.cd) {
                    this.invalid = true;
                }
            }

            public float getPercentile(float partTicks) {
                return 1.0f - Math.min(1.0f, ((float)this.elapsed + partTicks) / (float)this.cd);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="psi")
    public static class EventHandler {
        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                ArrayList<SpellContext> delayedContextsCopy = new ArrayList<SpellContext>(delayedContexts);
                for (SpellContext context : delayedContextsCopy) {
                    --context.delay;
                    if (context.delay > 0) continue;
                    context.delay = 0;
                    context.cspell.safeExecute(context);
                    if (context.delay != 0) continue;
                    delayedContexts.remove(context);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                ItemStack cadStack = PsiAPI.getPlayerCAD(player);
                if (!cadStack.func_190926_b() && cadStack.func_77973_b() instanceof ICAD && PsiAPI.canCADBeUpdated(player)) {
                    ((ICAD)cadStack.func_77973_b()).incrementTime(cadStack);
                }
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.tick"));
                PlayerDataHandler.get(player).tick();
            }
        }

        @SubscribeEvent
        public static void onEntityDamage(LivingHurtEvent event) {
            if (event.getEntityLiving() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                PlayerDataHandler.get(player).damage(event.getAmount());
                LivingEntity attacker = null;
                if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof LivingEntity) {
                    attacker = (LivingEntity)event.getSource().func_76346_g();
                }
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.damage", event.getAmount(), attacker));
                if (event.getSource().func_76347_k()) {
                    PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.on_fire"));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getPlayer() instanceof ServerPlayerEntity) {
                MessageDataSync message = new MessageDataSync(PlayerDataHandler.get(event.getPlayer()));
                MessageRegister.sendToPlayer(message, event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onEntityJump(LivingEvent.LivingJumpEvent event) {
            if (event.getEntityLiving() instanceof PlayerEntity && event.getEntity().field_70170_p.field_72995_K) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.jump"));
                MessageRegister.HANDLER.sendToServer((Object)new MessageTriggerJumpSpell());
            }
        }

        @SubscribeEvent
        public static void onPsiArmorEvent(PsiArmorEvent event) {
            for (int i = 0; i < 4; ++i) {
                ItemStack armor = (ItemStack)((PlayerEntity)event.getEntityLiving()).field_71071_by.field_70460_b.get(i);
                if (armor.func_190926_b() || !(armor.func_77973_b() instanceof IPsiEventArmor)) continue;
                IPsiEventArmor handler = (IPsiEventArmor)armor.func_77973_b();
                handler.onEvent(armor, event);
            }
        }

        @SubscribeEvent
        public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            PlayerDataHandler.get((PlayerEntity)event.getPlayer()).eidosChangelog.clear();
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onRenderWorldLast(RenderWorldLastEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            Entity cameraEntity = mc.func_175606_aa();
            if (cameraEntity != null) {
                float partialTicks = event.getPartialTicks();
                for (PlayerEntity player : mc.field_71441_e.func_217369_A()) {
                    PlayerDataHandler.get(player).render(player, partialTicks, event.getMatrixStack());
                }
            }
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onFOVUpdate(FOVUpdateEvent event) {
            PlayerData data = PlayerDataHandler.get((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
            if (data.isAnchored) {
                float fov = event.getNewfov();
                fov = data.eidosAnchorTime > 0 ? (fov *= Math.min(5.0f, (float)data.eidosAnchorTime - ClientTickHandler.partialTicks) / 5.0f) : (fov *= (10.0f - Math.min(10.0f, (float)data.postAnchorRecallTime + ClientTickHandler.partialTicks)) / 10.0f);
                event.setNewfov(fov);
            }
        }
    }
}

