/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ISocketableController;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.client.core.handler.KeybindHandler;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageChangeControllerSlot;
import vazkii.psi.common.network.message.MessageChangeSocketableSlot;

public class GuiSocketSelect
extends Screen {
    private static final ResourceLocation[] signs = new ResourceLocation[]{new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 0)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 1)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 2)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 3)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 4)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 5)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 6)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 7)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 8)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 9)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 10)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 11)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 12))};
    int timeIn = 0;
    int slotSelected = -1;
    ItemStack controllerStack;
    ISocketableController controller;
    ItemStack[] controlledStacks;
    int controlSlot;
    ItemStack socketableStack;
    ISocketable socketable;
    List<Integer> slots;
    final Minecraft mc = Minecraft.func_71410_x();

    public GuiSocketSelect(ItemStack stack) {
        super((ITextComponent)new StringTextComponent(""));
        this.controllerStack = ItemStack.field_190927_a;
        this.socketableStack = ItemStack.field_190927_a;
        if (ISocketable.isSocketable(stack)) {
            this.setSocketable(stack);
        } else if (stack.func_77973_b() instanceof ISocketableController) {
            this.controllerStack = stack;
            this.controller = (ISocketableController)stack.func_77973_b();
            this.controlledStacks = this.controller.getControlledStacks((PlayerEntity)this.mc.field_71439_g, stack);
            this.controlSlot = this.controller.getDefaultControlSlot(this.controllerStack);
            if (this.controlSlot >= this.controlledStacks.length) {
                this.controlSlot = 0;
            }
            this.setSocketable(this.controlledStacks.length == 0 ? ItemStack.field_190927_a : this.controlledStacks[this.controlSlot]);
        }
    }

    public void setSocketable(ItemStack stack) {
        this.slots = new ArrayList<Integer>();
        if (stack.func_190926_b()) {
            return;
        }
        this.socketableStack = stack;
        this.socketable = ISocketable.socketable(stack);
        for (int i = 0; i < 12; ++i) {
            if (!this.socketable.showSlotInRadialMenu(i)) continue;
            this.slots.add(i);
        }
    }

    public void func_230430_a_(MatrixStack ms, int mx, int my, float partialTicks) {
        float radius;
        boolean mouseInSector;
        int seg;
        super.func_230430_a_(ms, mx, my, partialTicks);
        int x = this.field_230708_k_ / 2;
        int y = this.field_230709_l_ / 2;
        int maxRadius = 80;
        double angle = GuiSocketSelect.mouseAngle(x, y, mx, my);
        int segments = this.slots.size();
        float step = (float)Math.PI / 180;
        float degPer = (float)Math.PI * 2 / (float)segments;
        ItemStack cadStack = PsiAPI.getPlayerCAD((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        this.slotSelected = -1;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        RenderSystem.disableCull();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.shadeModel((int)7425);
        buf.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        for (seg = 0; seg < segments; ++seg) {
            mouseInSector = (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
            radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector || seg == this.socketable.getSelectedSlot()) {
                radius *= 1.025f;
            }
            int gs = 64;
            if (seg % 2 == 0) {
                gs += 25;
            }
            int r = gs;
            int g = gs;
            int b = gs;
            int a = 102;
            if (seg == 0) {
                buf.func_225582_a_((double)x, (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            }
            if (mouseInSector) {
                this.slotSelected = seg;
                if (!cadStack.func_190926_b()) {
                    int color = Psi.proxy.getColorForCAD(cadStack);
                    r = PsiRenderHelper.r(color);
                    g = PsiRenderHelper.g(color);
                    b = PsiRenderHelper.b(color);
                } else {
                    b = 255;
                    g = 255;
                    r = 255;
                }
            } else if (seg == this.socketable.getSelectedSlot()) {
                if (!cadStack.func_190926_b()) {
                    int color = Psi.proxy.getColorForCAD(cadStack);
                    r = 255 - PsiRenderHelper.r(color);
                    g = 255 - PsiRenderHelper.g(color);
                    b = 255 - PsiRenderHelper.b(color);
                } else {
                    r = 0;
                    g = 255;
                    b = 0;
                }
            }
            for (float i = 0.0f; i < degPer + step / 2.0f; i += step) {
                float rad = i + (float)seg * degPer;
                float xp = (float)x + MathHelper.func_76134_b((float)rad) * radius;
                float yp = (float)y + MathHelper.func_76126_a((float)rad) * radius;
                if (i == 0.0f) {
                    buf.func_225582_a_((double)xp, (double)yp, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
                }
                buf.func_225582_a_((double)xp, (double)yp, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            }
        }
        tess.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableTexture();
        for (seg = 0; seg < segments; ++seg) {
            mouseInSector = (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
            radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector || seg == this.socketable.getSelectedSlot()) {
                radius *= 1.025f;
            }
            float rad = ((float)seg + 0.5f) * degPer;
            float xp = (float)x + MathHelper.func_76134_b((float)rad) * radius;
            float yp = (float)y + MathHelper.func_76126_a((float)rad) * radius;
            ItemStack stack = this.socketable.getBulletInSocket(seg);
            if (stack.func_190926_b()) continue;
            float xsp = xp - 4.0f;
            float ysp = yp;
            String name = (mouseInSector ? TextFormatting.UNDERLINE : TextFormatting.RESET) + stack.func_200301_q().getString();
            int width = this.field_230712_o_.func_78256_a(name);
            double mod = 0.6;
            int xdp = (int)((double)(xp - (float)x) * mod + (double)x);
            int ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            this.mc.func_175599_af().func_175042_a(stack, xdp - 8, ydp - 8);
            if (xsp < (float)x) {
                xsp -= (float)(width - 8);
            }
            if (ysp < (float)y) {
                ysp -= 9.0f;
            }
            this.field_230712_o_.func_238405_a_(ms, name, xsp, ysp, 0xFFFFFF);
            if (seg == this.socketable.getSelectedSlot()) {
                int color = 65280;
                if (!cadStack.func_190926_b()) {
                    color = 0xFF0000 - Psi.proxy.getColorForCAD(cadStack);
                }
                String string = I18n.func_135052_a((String)"psimisc.selected", (Object[])new Object[0]);
                float f = xsp + (float)(width / 4);
                this.field_230712_o_.getClass();
                this.field_230712_o_.func_238405_a_(ms, string, f, ysp + 9.0f, color);
            }
            mod = 0.8;
            xdp = (int)((double)(xp - (float)x) * mod + (double)x);
            ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            this.mc.field_71446_o.func_110577_a(signs[seg]);
            GuiSocketSelect.func_238463_a_((MatrixStack)ms, (int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        float shift = Math.min(5.0f, (float)this.timeIn + partialTicks) / 5.0f;
        float scale = 3.0f * shift;
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.enableLighting();
        RenderSystem.enableColorMaterial();
        if (this.controlledStacks != null && this.controlledStacks.length > 0) {
            int xs = this.field_230708_k_ / 2 - 18 * this.controlledStacks.length / 2;
            int ys = this.field_230709_l_ / 2;
            for (int i = 0; i < this.controlledStacks.length; ++i) {
                float yoff = 25.0f + (float)maxRadius;
                if (i == this.controlSlot) {
                    yoff += 5.0f;
                }
                ItemStack stack = this.controlledStacks[i];
                float rx = (float)(xs + i * 18) + -yoff * shift;
                PsiRenderHelper.transferMsToGl(ms, () -> this.mc.func_175599_af().func_180450_b(stack, (int)rx, ys));
            }
        }
        if (!this.socketableStack.func_190926_b()) {
            ms.func_227860_a_();
            ms.func_227862_a_(scale, scale, scale);
            PsiRenderHelper.transferMsToGl(ms, () -> this.mc.func_175599_af().func_180450_b(this.socketableStack, (int)((float)x / scale) - 8, (int)((float)y / scale) - 8));
            ms.func_227865_b_();
        }
        RenderHelper.func_74518_a();
        RenderSystem.disableBlend();
        RenderSystem.disableRescaleNormal();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        if (!this.controllerStack.func_190926_b() && this.controlledStacks.length > 0) {
            if (mouseButton == 0) {
                ++this.controlSlot;
                if (this.controlSlot >= this.controlledStacks.length) {
                    this.controlSlot = 0;
                }
            } else if (mouseButton == 1) {
                --this.controlSlot;
                if (this.controlSlot < 0) {
                    this.controlSlot = this.controlledStacks.length - 1;
                }
            }
            this.setSocketable(this.controlledStacks[this.controlSlot]);
            return true;
        }
        return false;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (!this.isKeyDown(KeybindHandler.keybind)) {
            this.mc.func_147108_a(null);
            if (this.slotSelected != -1) {
                int slot = this.slots.get(this.slotSelected);
                PlayerDataHandler.get((PlayerEntity)this.mc.field_71439_g).stopLoopcast();
                Object message = !this.controllerStack.func_190926_b() ? new MessageChangeControllerSlot(this.controlSlot, slot) : new MessageChangeSocketableSlot(slot);
                MessageRegister.HANDLER.sendToServer(message);
            }
        }
        ImmutableSet set = ImmutableSet.of((Object)this.mc.field_71474_y.field_74351_w, (Object)this.mc.field_71474_y.field_74370_x, (Object)this.mc.field_71474_y.field_74368_y, (Object)this.mc.field_71474_y.field_74366_z, (Object)this.mc.field_71474_y.field_228046_af_, (Object)this.mc.field_71474_y.field_151444_V, (Object[])new KeyBinding[]{this.mc.field_71474_y.field_74314_A});
        for (KeyBinding k : set) {
            KeyBinding.func_197980_a((InputMappings.Input)k.getKey(), (boolean)this.isKeyDown(k));
        }
        ++this.timeIn;
    }

    public boolean isKeyDown(KeyBinding keybind) {
        InputMappings.Input key = keybind.getKey();
        if (key.func_197938_b() == InputMappings.Type.MOUSE) {
            return keybind.func_151470_d();
        }
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key.func_197937_c());
    }

    public boolean func_231177_au__() {
        return false;
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (MathHelper.func_181159_b((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }
}

