/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.CompiledSpell;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.core.helper.SharingHelper;
import vazkii.psi.client.gui.button.GuiButtonHelp;
import vazkii.psi.client.gui.button.GuiButtonIO;
import vazkii.psi.client.gui.button.GuiButtonSideConfig;
import vazkii.psi.client.gui.widget.CallbackTextFieldWidget;
import vazkii.psi.client.gui.widget.PiecePanelWidget;
import vazkii.psi.client.gui.widget.SideConfigWidget;
import vazkii.psi.client.gui.widget.SpellCostsWidget;
import vazkii.psi.client.gui.widget.StatusWidget;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageSpellModified;
import vazkii.psi.common.spell.SpellCompiler;
import vazkii.psi.mixin.client.AccessorRenderState;

public class GuiProgrammer
extends Screen {
    public static final ResourceLocation texture = new ResourceLocation("psi:textures/gui/programmer.png");
    public static final RenderType LAYER;
    public final TileProgrammer programmer;
    public Spell spell;
    public List<ITextComponent> tooltip = new ArrayList<ITextComponent>();
    public final Stack<Spell> undoSteps = new Stack();
    public final Stack<Spell> redoSteps = new Stack();
    public static SpellPiece clipboard;
    public Either<CompiledSpell, SpellCompilationException> compileResult;
    public int xSize;
    public int ySize;
    public int padLeft;
    public int padTop;
    public int left;
    public int top;
    public int gridLeft;
    public int gridTop;
    public int cursorX;
    public int cursorY;
    public static int selectedX;
    public static int selectedY;
    public boolean commentEnabled;
    public GuiButtonHelp helpButton;
    public TextFieldWidget spellNameField;
    public TextFieldWidget commentField;
    public PiecePanelWidget panelWidget;
    public SideConfigWidget configWidget;
    public SpellCostsWidget spellCostsWidget;
    public StatusWidget statusWidget;
    public ITooltipFlag tooltipFlag;
    public boolean takingScreenshot = false;
    public boolean shareToReddit = false;
    boolean spectator;

    public GuiProgrammer(TileProgrammer programmer) {
        this(programmer, programmer.spell);
    }

    public GuiProgrammer(TileProgrammer tile, Spell spell) {
        super((ITextComponent)new StringTextComponent(""));
        this.programmer = tile;
        this.spell = spell;
        this.compileResult = new SpellCompiler().compile(spell);
    }

    protected void func_231160_c_() {
        this.xSize = 174;
        this.ySize = 184;
        this.padLeft = 7;
        this.padTop = 7;
        this.left = (this.field_230708_k_ - this.xSize) / 2;
        this.top = (this.field_230709_l_ - this.ySize) / 2;
        this.gridLeft = this.left + this.padLeft;
        this.gridTop = this.top + this.padTop;
        this.cursorY = -1;
        this.cursorX = -1;
        ITooltipFlag.TooltipFlags tooltipFlags = this.tooltipFlag = this.getMinecraft().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        this.spectator = this.programmer == null ? false : !this.programmer.playerLock.isEmpty() && !this.programmer.playerLock.equals(this.getMinecraft().field_71439_g.func_200200_C_().getString());
        this.statusWidget = (StatusWidget)this.func_230480_a_(new StatusWidget(this.left - 48, this.top + 5, 48, 30, "", this));
        this.spellCostsWidget = (SpellCostsWidget)this.func_230480_a_(new SpellCostsWidget(this.left + this.xSize + 3, this.top + (this.takingScreenshot ? 40 : 20), 100, 126, "", this));
        this.panelWidget = (PiecePanelWidget)this.func_230480_a_(new PiecePanelWidget(0, 0, 100, 125, "", this));
        this.helpButton = (GuiButtonHelp)this.func_230480_a_((Widget)new GuiButtonHelp(this.left + this.xSize + 2, this.top + this.ySize - (this.spectator ? 32 : 48), this));
        this.configWidget = (SideConfigWidget)this.func_230480_a_(new SideConfigWidget(this.left - 81, this.top + 55, 81, 115, this));
        this.spellNameField = (TextFieldWidget)this.func_230480_a_((Widget)new CallbackTextFieldWidget(this.getMinecraft().field_71466_p, this.left + this.xSize - 130, this.top + this.ySize - 14, 120, 10, button -> {
            this.spell.name = this.spellNameField.func_146179_b();
            this.onSpellChanged(true);
        }));
        this.spellNameField.func_146185_a(false);
        this.spellNameField.func_146203_f(20);
        this.spellNameField.func_146184_c(!this.spectator);
        this.commentField = (TextFieldWidget)this.func_230480_a_((Widget)new CallbackTextFieldWidget(this.getMinecraft().field_71466_p, this.left, this.top + this.ySize / 2 - 10, this.xSize, 20, button -> {}));
        this.commentField.func_146184_c(false);
        this.commentField.func_146189_e(false);
        this.commentField.func_146203_f(500);
        this.panelWidget.searchField = (TextFieldWidget)this.func_230480_a_((Widget)new CallbackTextFieldWidget(this.getMinecraft().field_71466_p, 0, 0, 70, 10, button -> {
            this.panelWidget.page = 0;
            this.panelWidget.updatePanelButtons();
        }));
        this.panelWidget.searchField.func_146184_c(false);
        this.panelWidget.searchField.func_146189_e(false);
        this.panelWidget.searchField.func_146185_a(false);
        if (this.spell == null) {
            this.spell = new Spell();
        }
        if (this.programmer != null && this.programmer.spell == null) {
            this.programmer.spell = this.spell;
        }
        this.spellNameField.func_146180_a(this.spell.name);
        this.panelWidget.populatePanelButtons();
        this.onSelectedChanged();
        this.func_230480_a_((Widget)new GuiButtonIO(this.left + this.xSize + 2, this.top + this.ySize - (this.spectator ? 16 : 32), true, this, button -> {
            if (GuiProgrammer.func_231173_s_()) {
                CompoundNBT cmp = new CompoundNBT();
                if (this.spell != null) {
                    this.spell.writeToNBT(cmp);
                }
                this.getMinecraft().field_195559_v.func_197960_a(cmp.toString());
            }
        }));
        if (!this.spectator) {
            this.func_230480_a_((Widget)new GuiButtonIO(this.left + this.xSize + 2, this.top + this.ySize - 16, false, this, button -> {
                if (GuiProgrammer.func_231173_s_()) {
                    String cb = this.getMinecraft().field_195559_v.func_197965_a();
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    try {
                        cb = cb.replaceAll("([^a-z0-9])\\d+:", "$1");
                        CompoundNBT cmp = JsonToNBT.func_180713_a((String)cb);
                        if (cmp.func_74764_b("modsRequired")) {
                            ListNBT mods = (ListNBT)cmp.func_74781_a("modsRequired");
                            for (INBT mod : mods) {
                                String modName = ((CompoundNBT)mod).func_74779_i("modName");
                                if (!PsiAPI.getSpellPieceRegistry().func_148742_b().stream().map(ResourceLocation::func_110624_b).collect(Collectors.toSet()).contains(modName)) {
                                    player.func_145747_a((ITextComponent)new TranslationTextComponent("psimisc.modnotfound", new Object[]{modName}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), Util.field_240973_b_);
                                }
                                if (!modName.equals("psi")) continue;
                                boolean sendMessage = false;
                                String modVersion = ((CompoundNBT)mod).func_74779_i("modVersion");
                                int[] versionEntry = Arrays.stream(modVersion.replaceFirst("^\\D+", "").split("\\D+")).mapToInt(Integer::parseInt).toArray();
                                int[] currentVersion = Arrays.stream(((ModContainer)ModList.get().getModContainerById("psi").get()).getModInfo().getVersion().toString().replaceFirst("^\\D+", "").split("\\D+")).mapToInt(Integer::parseInt).toArray();
                                for (int i = 0; i < versionEntry.length; ++i) {
                                    if (i + 1 > currentVersion.length) {
                                        sendMessage = true;
                                        break;
                                    }
                                    if (currentVersion[i] > versionEntry[i]) break;
                                    if (currentVersion[i] >= versionEntry[i]) continue;
                                    sendMessage = true;
                                    break;
                                }
                                if (!sendMessage) continue;
                                player.func_145747_a((ITextComponent)new TranslationTextComponent("psimisc.spellonnewerversion").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), Util.field_240973_b_);
                            }
                        }
                        this.spell = Spell.createFromNBT(cmp);
                        if (this.spell == null) {
                            return;
                        }
                        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((PlayerEntity)player);
                        for (int i = 0; i < 9; ++i) {
                            for (int j = 0; j < 9; ++j) {
                                SpellPiece piece = this.spell.grid.gridData[i][j];
                                if (piece == null) continue;
                                ResourceLocation group = PsiAPI.getGroupForPiece(piece.getClass());
                                if (player.func_184812_l_() || group != null && data.isPieceGroupUnlocked(group, piece.registryKey)) continue;
                                player.func_145747_a((ITextComponent)new TranslationTextComponent("psimisc.missing_pieces").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), Util.field_240973_b_);
                                return;
                            }
                        }
                        this.pushState(true);
                        this.spellNameField.func_146180_a(this.spell.name);
                        this.onSpellChanged(false);
                    }
                    catch (Exception t) {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("psimisc.malformed_json", new Object[]{t.getMessage()}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), Util.field_240973_b_);
                        Psi.logger.error("Error importing spell from clipboard", (Throwable)t);
                    }
                }
            }));
        }
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        if (!(this.programmer == null || this.programmer.func_145831_w().func_175625_s(this.programmer.func_174877_v()) == this.programmer && this.programmer.canPlayerInteract((PlayerEntity)this.getMinecraft().field_71439_g))) {
            this.getMinecraft().func_147108_a(null);
            return;
        }
        String comment = "";
        int color = Psi.magical ? 0 : 0xFFFFFF;
        ms.func_227860_a_();
        this.func_230446_a_(ms);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(texture);
        this.func_238474_b_(ms, this.left, this.top, 0, 0, this.xSize, this.ySize);
        SpellPiece piece = null;
        if (SpellGrid.exists(selectedX, selectedY)) {
            piece = this.spell.grid.gridData[selectedX][selectedY];
        }
        this.cursorX = (mouseX - this.gridLeft) / 18;
        this.cursorY = (mouseY - this.gridTop) / 18;
        if (this.panelWidget.panelEnabled || this.cursorX > 8 || this.cursorY > 8 || this.cursorX < 0 || this.cursorY < 0 || mouseX < this.gridLeft || mouseY < this.gridTop) {
            this.cursorX = -1;
            this.cursorY = -1;
        }
        ms.func_227860_a_();
        this.tooltip.clear();
        ms.func_227861_a_((double)this.gridLeft, (double)this.gridTop, 0.0);
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        this.spell.draw(ms, (IRenderTypeBuffer)buffers, 0xF000F0);
        buffers.func_228461_a_();
        this.compileResult.right().ifPresent(ex -> {
            Pair<Integer, Integer> errorPos = ex.location;
            if (errorPos != null && (Integer)errorPos.getRight() != -1 && (Integer)errorPos.getLeft() != -1) {
                this.field_230712_o_.func_238405_a_(ms, "!!", (float)((Integer)errorPos.getLeft() * 18 + 12), (float)((Integer)errorPos.getRight() * 18 + 8), 0xFF0000);
            }
        });
        ms.func_227865_b_();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        ms.func_227861_a_(0.0, 0.0, 1.0);
        this.getMinecraft().func_110434_K().func_110577_a(texture);
        if (selectedX != -1 && selectedY != -1 && !this.takingScreenshot) {
            this.func_238474_b_(ms, this.gridLeft + selectedX * 18, this.gridTop + selectedY * 18, 32, this.ySize, 16, 16);
        }
        if (GuiProgrammer.func_231174_t_()) {
            this.tooltip.clear();
            this.cursorX = selectedX;
            this.cursorY = selectedY;
            mouseX = this.gridLeft + this.cursorX * 18 + 10;
            mouseY = this.gridTop + this.cursorY * 18 + 8;
        }
        if (this.takingScreenshot) {
            Set addons = this.spell.getPieceNamespaces().stream().filter(namespace -> !namespace.equals("psi")).collect(Collectors.toSet());
            if (addons.size() > 0) {
                String requiredAddons = TextFormatting.GREEN + "Required Addons:";
                this.field_230712_o_.func_238405_a_(ms, requiredAddons, (float)(this.left - this.field_230712_o_.func_78256_a(requiredAddons) - 5), (float)(this.top + 40), 0xFFFFFF);
                int i = 1;
                for (String addon : addons) {
                    if (!ModList.get().getModContainerById(addon).isPresent()) continue;
                    String modName = ((ModContainer)ModList.get().getModContainerById(addon).get()).getModInfo().getDisplayName();
                    this.field_230712_o_.func_238405_a_(ms, "* " + modName, (float)(this.left - this.field_230712_o_.func_78256_a(requiredAddons) - 5), (float)(this.top + 40 + 10 * i), 0xFFFFFF);
                }
            }
            String version = "Psi " + ((ModContainer)ModList.get().getModContainerById("psi").get()).getModInfo().getVersion().toString();
            this.field_230712_o_.func_238405_a_(ms, version, (float)this.left + (float)this.xSize / 2.0f - (float)this.field_230712_o_.func_78256_a(version) / 2.0f, (float)(this.top - 22), 0xFFFFFF);
        }
        SpellPiece pieceAtCursor = null;
        if (this.cursorX != -1 && this.cursorY != -1) {
            pieceAtCursor = this.spell.grid.gridData[this.cursorX][this.cursorY];
            if (pieceAtCursor != null) {
                pieceAtCursor.getTooltip(this.tooltip);
                comment = pieceAtCursor.comment;
            }
            if (!this.takingScreenshot) {
                if (this.cursorX == selectedX && this.cursorY == selectedY) {
                    this.func_238474_b_(ms, this.gridLeft + this.cursorX * 18, this.gridTop + this.cursorY * 18, 16, this.ySize, 8, 16);
                } else {
                    this.func_238474_b_(ms, this.gridLeft + this.cursorX * 18, this.gridTop + this.cursorY * 18, 16, this.ySize, 16, 16);
                }
            }
        }
        int topY = this.top - 22;
        if (!this.takingScreenshot) {
            int topYText = topY;
            if (this.spectator) {
                String spectator = TextFormatting.RED + I18n.func_135052_a((String)"psimisc.spectator", (Object[])new Object[0]);
                this.field_230712_o_.func_238405_a_(ms, spectator, (float)this.left + (float)this.xSize / 2.0f - (float)this.field_230712_o_.func_78256_a(spectator) / 2.0f, (float)topYText, 0xFFFFFF);
                topYText -= 10;
            }
            if (piece != null) {
                String pieceName = I18n.func_135052_a((String)piece.getUnlocalizedName(), (Object[])new Object[0]);
                this.field_230712_o_.func_238405_a_(ms, pieceName, (float)this.left + (float)this.xSize / 2.0f - (float)this.field_230712_o_.func_78256_a(pieceName) / 2.0f, (float)topYText, 0xFFFFFF);
                topYText -= 10;
            }
            String coords = SpellGrid.exists(this.cursorX, this.cursorY) ? I18n.func_135052_a((String)"psimisc.programmer_coords", (Object[])new Object[]{selectedX + 1, selectedY + 1, this.cursorX + 1, this.cursorY + 1}) : I18n.func_135052_a((String)"psimisc.programmer_coords_no_cursor", (Object[])new Object[]{selectedX + 1, selectedY + 1});
            this.field_230712_o_.func_238421_b_(ms, coords, (float)(this.left + 4), (float)(topY + this.ySize + 24), 0x44FFFFFF);
        }
        if (Psi.magical) {
            this.field_230712_o_.func_238421_b_(ms, I18n.func_135052_a((String)"psimisc.name", (Object[])new Object[0]), (float)(this.left + this.padLeft), (float)(this.spellNameField.field_230691_m_ + 1), color);
        } else {
            this.field_230712_o_.func_238405_a_(ms, I18n.func_135052_a((String)"psimisc.name", (Object[])new Object[0]), (float)(this.left + this.padLeft), (float)(this.spellNameField.field_230691_m_ + 1), color);
        }
        if (this.commentEnabled) {
            String enterCommit = I18n.func_135052_a((String)"psimisc.enter_commit", (Object[])new Object[0]);
            this.field_230712_o_.func_238405_a_(ms, enterCommit, (float)this.left + (float)this.xSize / 2.0f - (float)this.field_230712_o_.func_78256_a(enterCommit) / 2.0f, (float)(this.commentField.field_230691_m_ + 24), 0xFFFFFF);
            String semicolonLine = I18n.func_135052_a((String)"psimisc.semicolon_line", (Object[])new Object[0]);
            this.field_230712_o_.func_238405_a_(ms, semicolonLine, (float)this.left + (float)this.xSize / 2.0f - (float)this.field_230712_o_.func_78256_a(semicolonLine) / 2.0f, (float)(this.commentField.field_230691_m_ + 34), 0xFFFFFF);
        }
        ArrayList<ITextComponent> legitTooltip = null;
        if (GuiProgrammer.func_231174_t_()) {
            legitTooltip = new ArrayList<ITextComponent>(this.tooltip);
        }
        if (GuiProgrammer.func_231174_t_()) {
            this.tooltip = legitTooltip;
        }
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        if (!this.takingScreenshot && this.tooltip != null && !this.tooltip.isEmpty() && pieceAtCursor == null) {
            GuiUtils.drawHoveringText((MatrixStack)ms, this.tooltip, (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
        if (!this.takingScreenshot && pieceAtCursor != null) {
            if (this.tooltip != null && !this.tooltip.isEmpty()) {
                pieceAtCursor.drawTooltip(ms, mouseX, mouseY, this.tooltip, this);
            }
            if (comment != null && !comment.isEmpty()) {
                List<ITextComponent> commentList = Arrays.stream(comment.split(";")).map(StringTextComponent::new).collect(Collectors.toList());
                pieceAtCursor.drawCommentText(ms, mouseX, mouseY, commentList, this);
            }
        }
        ms.func_227865_b_();
        if (this.takingScreenshot) {
            String name = this.spell.name;
            CompoundNBT cmp = new CompoundNBT();
            if (this.spell != null) {
                this.spell.writeToNBT(cmp);
            }
            String export = cmp.toString();
            if (this.shareToReddit) {
                SharingHelper.uploadAndShare(name, export);
            } else {
                SharingHelper.uploadAndOpen(name, export);
            }
            this.takingScreenshot = false;
            this.shareToReddit = false;
        }
    }

    public void removeButtons(List<Button> list) {
        this.removeButtonList(list);
    }

    private void removeButtonList(List<Button> list) {
        this.field_230710_m_.removeAll(list);
        this.field_230705_e_.removeAll(list);
    }

    public void addButtons(List<Button> list) {
        list.forEach(arg_0 -> ((GuiProgrammer)this).func_230480_a_(arg_0));
    }

    public void pushState(boolean wipeRedo) {
        if (wipeRedo) {
            this.redoSteps.clear();
        }
        this.undoSteps.push(this.spell.copy());
        if (this.undoSteps.size() > 25) {
            this.undoSteps.remove(0);
        }
    }

    public void onSpellChanged(boolean nameOnly) {
        if (this.programmer != null) {
            if (!this.spectator) {
                MessageSpellModified message = new MessageSpellModified(this.programmer.func_174877_v(), this.spell);
                MessageRegister.HANDLER.sendToServer((Object)message);
            }
            this.programmer.spell = this.spell;
            this.programmer.onSpellChanged();
        }
        this.onSelectedChanged();
        if (!nameOnly || this.compileResult.right().filter(ex -> ex.getMessage().equals("psi.spellerror.noname")).isPresent() || this.spell.name.isEmpty()) {
            this.compileResult = new SpellCompiler().compile(this.spell);
        }
    }

    public void onSelectedChanged() {
        SpellPiece piece;
        this.field_230710_m_.removeAll(this.configWidget.configButtons);
        this.field_230705_e_.removeAll(this.configWidget.configButtons);
        this.configWidget.configButtons.clear();
        this.spellNameField.func_146184_c(!this.spectator);
        if (selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null) {
            boolean intercept = piece.interceptKeystrokes();
            this.spellNameField.func_146184_c(!this.spectator && !intercept);
            if (piece.hasConfig()) {
                int i = 0;
                for (String paramName : piece.params.keySet()) {
                    SpellParam<?> param = piece.params.get(paramName);
                    int x = this.left - 17;
                    int y = this.top + 70 + i * 26;
                    for (SpellParam.Side side : ImmutableSet.of((Object)((Object)SpellParam.Side.TOP), (Object)((Object)SpellParam.Side.BOTTOM), (Object)((Object)SpellParam.Side.LEFT), (Object)((Object)SpellParam.Side.RIGHT), (Object)((Object)SpellParam.Side.OFF))) {
                        if (!side.isEnabled() && !param.canDisable) continue;
                        int xp = x + side.offx * 8;
                        int yp = y + side.offy * 8;
                        this.configWidget.configButtons.add(new GuiButtonSideConfig(this, selectedX, selectedY, i, paramName, side, xp, yp, button -> {
                            if (!this.spectator) {
                                this.pushState(true);
                                GuiButtonSideConfig.performAction(this, selectedX, selectedY, paramName, side);
                                this.onSpellChanged(false);
                            }
                        }));
                    }
                    ++i;
                }
                this.configWidget.configButtons.forEach(arg_0 -> ((GuiProgrammer)this).func_230480_a_(arg_0));
                this.configWidget.configEnabled = true;
                return;
            }
        }
        this.configWidget.configEnabled = false;
    }

    public boolean func_231042_a_(char character, int keyCode) {
        SpellPiece piece;
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (this.spectator) {
            return false;
        }
        super.func_231042_a_(character, keyCode);
        if (!this.commentEnabled && !this.spellNameField.func_230999_j_() && selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null && piece.interceptKeystrokes() && piece.onCharTyped(character, keyCode, false)) {
            this.pushState(true);
            piece.onCharTyped(character, keyCode, true);
            this.onSpellChanged(false);
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (keyCode == 256 && this.func_231178_ax__()) {
            this.func_231175_as__();
            return true;
        }
        if (this.spectator) {
            return true;
        }
        if (this.commentEnabled) {
            switch (keyCode) {
                case 257: {
                    this.closeComment(true);
                    return true;
                }
                case 256: {
                    this.closeComment(false);
                    return true;
                }
            }
        }
        SpellPiece piece = null;
        if (selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null && piece.interceptKeystrokes() && piece.onKeyPressed(keyCode, scanCode, false)) {
            this.pushState(true);
            piece.onKeyPressed(keyCode, scanCode, true);
            this.onSpellChanged(false);
            return true;
        }
        if (this.spellNameField.func_230999_j_() && keyCode == 258) {
            this.spellNameField.func_146195_b(false);
            this.func_212928_a(null);
            return true;
        }
        if (!(this.spellNameField.func_230999_j_() || this.panelWidget.panelEnabled || this.commentEnabled)) {
            int param = -1;
            for (int i = 0; i < 4; ++i) {
                if (!InputMappings.func_216506_a((long)this.getMinecraft().func_228018_at_().func_198092_i(), (int)(49 + i))) continue;
                param = i;
            }
            switch (keyCode) {
                case 259: 
                case 261: {
                    if (GuiProgrammer.func_231172_r_() && GuiProgrammer.func_231173_s_() && !this.spell.grid.isEmpty()) {
                        this.pushState(true);
                        this.spell = new Spell();
                        this.spellNameField.func_146180_a("");
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (piece == null) break;
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                case 258: {
                    this.spellNameField.func_146195_b(!this.spellNameField.func_230999_j_());
                    this.func_212928_a((IGuiEventListener)this.spellNameField);
                    return true;
                }
                case 265: {
                    if (GuiProgrammer.func_231172_r_()) {
                        if (GuiProgrammer.func_231173_s_()) {
                            this.pushState(true);
                            this.spell.grid.mirrorVertical();
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.TOP, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.TOP, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.TOP) || selectedY <= 0) break;
                    --selectedY;
                    this.onSelectedChanged();
                    return true;
                }
                case 263: {
                    if (GuiProgrammer.func_231172_r_()) {
                        if (GuiProgrammer.func_231173_s_()) {
                            this.pushState(true);
                            this.spell.grid.rotate(false);
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.LEFT, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.LEFT, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.LEFT) || selectedX <= 0) break;
                    --selectedX;
                    this.onSelectedChanged();
                    return true;
                }
                case 262: {
                    if (GuiProgrammer.func_231172_r_()) {
                        if (GuiProgrammer.func_231173_s_()) {
                            this.pushState(true);
                            this.spell.grid.rotate(true);
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.RIGHT, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.RIGHT, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.RIGHT) || selectedX >= 8) break;
                    ++selectedX;
                    this.onSelectedChanged();
                    return true;
                }
                case 264: {
                    if (GuiProgrammer.func_231172_r_()) {
                        if (GuiProgrammer.func_231173_s_()) {
                            this.pushState(true);
                            this.spell.grid.mirrorVertical();
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.BOTTOM, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.BOTTOM, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.BOTTOM) || selectedY >= 8) break;
                    ++selectedY;
                    this.onSelectedChanged();
                    return true;
                }
                case 90: {
                    if (!GuiProgrammer.func_231172_r_() || this.undoSteps.isEmpty()) break;
                    this.redoSteps.add(this.spell.copy());
                    this.spell = this.undoSteps.pop();
                    this.onSpellChanged(false);
                    return true;
                }
                case 89: {
                    if (!GuiProgrammer.func_231172_r_() || this.redoSteps.isEmpty()) break;
                    this.pushState(false);
                    this.spell = this.redoSteps.pop();
                    this.onSpellChanged(false);
                    return true;
                }
                case 67: {
                    if (piece == null || !GuiProgrammer.func_231172_r_()) break;
                    clipboard = piece.copy();
                    return true;
                }
                case 88: {
                    if (piece == null || !GuiProgrammer.func_231172_r_()) break;
                    clipboard = piece.copy();
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                case 86: {
                    if (!SpellGrid.exists(selectedX, selectedY) || clipboard == null || !GuiProgrammer.func_231172_r_()) break;
                    SpellPiece copy = clipboard.copy();
                    copy.x = selectedX;
                    copy.y = selectedY;
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = copy;
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY].isInGrid = true;
                    this.onSpellChanged(false);
                    return true;
                }
                case 68: {
                    if (piece == null || !GuiProgrammer.func_231172_r_()) break;
                    this.commentField.func_146189_e(true);
                    this.commentField.func_146195_b(true);
                    this.commentField.func_146184_c(true);
                    this.spellNameField.func_146184_c(false);
                    this.commentField.func_146180_a(piece.comment);
                    this.commentField.func_146195_b(true);
                    this.func_212928_a((IGuiEventListener)this.commentField);
                    this.commentEnabled = true;
                    return true;
                }
                case 71: {
                    if (!GuiProgrammer.func_231172_r_()) break;
                    this.shareToReddit = false;
                    if (GuiProgrammer.func_231173_s_() && GuiProgrammer.func_231174_t_()) {
                        this.takingScreenshot = true;
                    }
                    return true;
                }
                case 82: {
                    if (!GuiProgrammer.func_231172_r_()) break;
                    this.shareToReddit = true;
                    if (GuiProgrammer.func_231173_s_() && GuiProgrammer.func_231174_t_()) {
                        this.takingScreenshot = true;
                    }
                    return true;
                }
                case 257: {
                    this.panelWidget.openPanel();
                    return true;
                }
            }
        }
        if (this.panelWidget.panelEnabled) {
            this.panelWidget.func_231046_a_(keyCode, scanCode, modifiers);
        }
        if (this.commentField.func_230999_j_()) {
            this.commentField.func_231046_a_(keyCode, scanCode, modifiers);
        }
        if (this.spellNameField.func_230999_j_()) {
            this.spellNameField.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean onSideButtonKeybind(SpellPiece piece, int param, SpellParam.Side side) {
        if (param > -1 && piece != null && piece.params.size() >= param) {
            for (Button button : this.configWidget.configButtons) {
                GuiButtonSideConfig config = (GuiButtonSideConfig)button;
                if (!config.matches(param, side)) continue;
                if (side != SpellParam.Side.OFF && piece.paramSides.get(piece.params.get(config.paramName)) == side) {
                    side = SpellParam.Side.OFF;
                    continue;
                }
                config.func_230930_b_();
                return true;
            }
        }
        return side == SpellParam.Side.OFF;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (!this.commentEnabled) {
            this.spellNameField.func_231044_a_(mouseX, mouseY, mouseButton);
            if (this.commentField.func_146176_q()) {
                this.commentField.func_231044_a_(mouseX, mouseY, mouseButton);
            }
            if (this.cursorX != -1 && this.cursorY != -1) {
                selectedX = this.cursorX;
                selectedY = this.cursorY;
                if (mouseButton == 1 && !this.spectator && GuiProgrammer.func_231173_s_()) {
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                this.onSelectedChanged();
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean isSpectator() {
        return this.spectator;
    }

    private void closeComment(boolean save) {
        SpellPiece piece = null;
        if (selectedX != -1 && selectedY != -1) {
            piece = this.spell.grid.gridData[selectedX][selectedY];
        }
        if (save && piece != null) {
            String text = this.commentField.func_146179_b();
            this.pushState(true);
            piece.comment = text;
            this.onSpellChanged(false);
        }
        this.spellNameField.func_146184_c(!this.spectator && (piece == null || !piece.interceptKeystrokes()));
        this.commentField.func_146195_b(false);
        this.commentField.func_146189_e(false);
        this.commentField.func_146184_c(false);
        this.func_212928_a(null);
        this.commentField.func_146180_a("");
        this.commentEnabled = false;
    }

    public boolean func_231178_ax__() {
        return !this.panelWidget.panelEnabled && !this.commentEnabled;
    }

    public List<Widget> getButtons() {
        return this.field_230710_m_;
    }

    public boolean func_231177_au__() {
        return (Boolean)ConfigHandler.CLIENT.pauseGameInProgrammer.get();
    }

    static {
        RenderState.TransparencyState translucent = AccessorRenderState.getTranslucentTransprency();
        RenderType.State glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228719_a_(new RenderState.LightmapState(true)).func_228714_a_(new RenderState.CullState(false)).func_228713_a_(new RenderState.AlphaState(0.004f)).func_228726_a_(translucent).func_228728_a_(false);
        LAYER = RenderType.func_228632_a_((String)"psi:programmer", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)128, (RenderType.State)glState);
        clipboard = null;
    }
}

