/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.proxy;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.core.handler.ClientTickHandler;
import vazkii.psi.client.core.handler.ColorHandler;
import vazkii.psi.client.core.handler.ContributorSpellCircleHandler;
import vazkii.psi.client.core.handler.KeybindHandler;
import vazkii.psi.client.core.handler.ShaderHandler;
import vazkii.psi.client.fx.SparkleParticleData;
import vazkii.psi.client.fx.WispParticleData;
import vazkii.psi.client.gui.GuiProgrammer;
import vazkii.psi.client.model.ModelCAD;
import vazkii.psi.client.render.entity.RenderSpellCircle;
import vazkii.psi.client.render.entity.RenderSpellProjectile;
import vazkii.psi.client.render.tile.RenderTileProgrammer;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.proxy.IProxy;
import vazkii.psi.common.entity.EntitySpellCharge;
import vazkii.psi.common.entity.EntitySpellCircle;
import vazkii.psi.common.entity.EntitySpellGrenade;
import vazkii.psi.common.entity.EntitySpellMine;
import vazkii.psi.common.entity.EntitySpellProjectile;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.spell.other.PieceConnector;
import vazkii.psi.mixin.client.AccessorRenderBuffers;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
implements IProxy {
    @Override
    public void registerHandlers() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::modelBake);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addCADModels);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        KeybindHandler.init();
        ClientRegistry.bindTileEntityRenderer(TileProgrammer.TYPE, RenderTileProgrammer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellCircle.TYPE, RenderSpellCircle::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellCharge.TYPE, RenderSpellProjectile::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellGrenade.TYPE, RenderSpellProjectile::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellProjectile.TYPE, RenderSpellProjectile::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellMine.TYPE, RenderSpellProjectile::new);
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.conjured, (RenderType)RenderType.func_228645_f_());
        ContributorSpellCircleHandler.firstStart();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        DeferredWorkQueue.runLater(() -> {
            Map<RenderType, BufferBuilder> map = ((AccessorRenderBuffers)Minecraft.func_71410_x().func_228019_au_().func_228487_b_()).getFixedBuffers();
            RenderType layer = SpellPiece.getLayer();
            map.put(layer, new BufferBuilder(layer.func_228662_o_()));
            map.put(GuiProgrammer.LAYER, new BufferBuilder(GuiProgrammer.LAYER.func_228662_o_()));
            ColorHandler.init();
            ShaderHandler.init();
        });
    }

    private void modelBake(ModelBakeEvent event) {
        ModelResourceLocation key = new ModelResourceLocation(ModItems.cad.getRegistryName(), "inventory");
        event.getModelRegistry().put(key, new ModelCAD());
    }

    private void addCADModels(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("psi", "item/cad_iron"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("psi", "item/cad_gold"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("psi", "item/cad_psimetal"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("psi", "item/cad_ebony_psimetal"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("psi", "item/cad_ivory_psimetal"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("psi", "item/cad_creative"));
        ModelBakery.field_177602_b.addAll(ClientPsiAPI.getAllSpellPieceMaterial());
        ModelBakery.field_177602_b.add(new RenderMaterial(ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS, PieceConnector.LINES_TEXTURE));
    }

    @Override
    public boolean hasAdvancement(ResourceLocation advancement, PlayerEntity playerEntity) {
        if (playerEntity instanceof ClientPlayerEntity) {
            ClientPlayerEntity clientPlayerEntity = (ClientPlayerEntity)playerEntity;
            return clientPlayerEntity.field_71174_a.func_191982_f().func_194229_a().func_192084_a(advancement) != null;
        }
        if (playerEntity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)playerEntity;
            return serverPlayerEntity.func_184102_h().func_191949_aK().func_192778_a(advancement) != null && serverPlayerEntity.func_192039_O().func_192747_a(serverPlayerEntity.func_184102_h().func_191949_aK().func_192778_a(advancement)).func_192105_a();
        }
        return false;
    }

    @Override
    public void addParticleForce(World world, IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        world.func_195590_a(particleData, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public long getWorldElapsedTicks() {
        return ClientTickHandler.ticksInGame;
    }

    @Override
    public int getClientRenderDistance() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c;
    }

    @Override
    public int getColorForCAD(ItemStack cadStack) {
        ICAD icad = (ICAD)cadStack.func_77973_b();
        return icad.getSpellColor(cadStack);
    }

    @Override
    public int getColorForColorizer(ItemStack colorizer) {
        if (colorizer.func_190926_b() || !(colorizer.func_77973_b() instanceof ICADColorizer)) {
            return 1295871;
        }
        ICADColorizer icc = (ICADColorizer)colorizer.func_77973_b();
        return icc.getColor(colorizer);
    }

    @Override
    public void sparkleFX(World world, double x, double y, double z, float r, float g, float b, float motionx, float motiony, float motionz, float size, int m) {
        if (m == 0) {
            return;
        }
        SparkleParticleData data = new SparkleParticleData(size, r, g, b, m, motionx, motiony, motionz);
        this.addParticleForce(world, data, x, y, z, motionx, motiony, motionz);
    }

    @Override
    public void sparkleFX(double x, double y, double z, float r, float g, float b, float motionx, float motiony, float motionz, float size, int m) {
        this.sparkleFX((World)Minecraft.func_71410_x().field_71441_e, x, y, z, r, g, b, motionx, motiony, motionz, size, m);
    }

    @Override
    public void wispFX(World world, double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz, float maxAgeMul) {
        if (maxAgeMul == 0.0f) {
            return;
        }
        WispParticleData data = new WispParticleData(size, r, g, b, maxAgeMul);
        this.addParticleForce(world, data, x, y, z, motionx, motiony, motionz);
    }

    @Override
    public void wispFX(double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz, float maxAgeMul) {
        this.wispFX((World)Minecraft.func_71410_x().field_71441_e, x, y, z, r, g, b, size, motionx, motiony, motionz, maxAgeMul);
    }

    @Override
    public void openProgrammerGUI(TileProgrammer programmer) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiProgrammer(programmer));
    }
}

