/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.spell.IGenericRedirector;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;

public final class SpellGrid {
    private static final String TAG_SPELL_LIST = "spellList";
    private static final String TAG_SPELL_POS_X_LEGACY = "spellPosX";
    private static final String TAG_SPELL_POS_Y_LEGACY = "spellPosY";
    private static final String TAG_SPELL_DATA_LEGACY = "spellData";
    private static final String TAG_SPELL_POS_X = "x";
    private static final String TAG_SPELL_POS_Y = "y";
    private static final String TAG_SPELL_DATA = "data";
    public static final int GRID_SIZE = 9;
    public static final int GRID_CENTER = 4;
    public final Spell spell;
    public SpellPiece[][] gridData;
    private boolean empty;
    private int leftmost;
    private int rightmost;
    private int topmost;
    private int bottommost;

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece p = this.gridData[i][j];
                if (p == null) continue;
                ms.func_227860_a_();
                ms.func_227861_a_((double)(i * 18), (double)(j * 18), 0.0);
                p.draw(ms, buffers, light);
                ms.func_227865_b_();
            }
        }
    }

    private void recalculateBoundaries() {
        this.empty = true;
        this.leftmost = 9;
        this.rightmost = -1;
        this.topmost = 9;
        this.bottommost = -1;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece p = this.gridData[i][j];
                if (p == null) continue;
                this.empty = false;
                if (i < this.leftmost) {
                    this.leftmost = i;
                }
                if (i > this.rightmost) {
                    this.rightmost = i;
                }
                if (j < this.topmost) {
                    this.topmost = j;
                }
                if (j <= this.bottommost) continue;
                this.bottommost = j;
            }
        }
    }

    public int getSize() {
        this.recalculateBoundaries();
        if (this.empty) {
            return 0;
        }
        return Math.max(this.rightmost - this.leftmost + 1, this.bottommost - this.topmost + 1);
    }

    public void mirrorVertical() {
        this.recalculateBoundaries();
        if (this.empty) {
            return;
        }
        SpellPiece[][] newGrid = new SpellPiece[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece p = this.gridData[i][j];
                if (p == null) continue;
                int newY = 9 - j - 1;
                newGrid[i][newY] = p;
                p.y = newY;
                p.paramSides.replaceAll((k, v) -> p.paramSides.get(k).mirrorVertical());
            }
        }
        this.gridData = newGrid;
    }

    public void rotate(boolean ccw) {
        this.recalculateBoundaries();
        if (this.empty) {
            return;
        }
        int xMod = ccw ? -1 : 1;
        int yMod = ccw ? 1 : -1;
        SpellPiece[][] newGrid = new SpellPiece[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece p = this.gridData[i][j];
                if (p == null) continue;
                int newX = xMod * (j - 4) + 4;
                int newY = yMod * (i - 4) + 4;
                newGrid[newX][newY] = p;
                p.x = newX;
                p.y = newY;
                for (SpellParam<?> param : p.paramSides.keySet()) {
                    SpellParam.Side side = p.paramSides.get(param);
                    p.paramSides.put(param, ccw ? side.rotateCCW() : side.rotateCW());
                }
            }
        }
        this.gridData = newGrid;
    }

    public boolean shift(SpellParam.Side side, boolean doit) {
        this.recalculateBoundaries();
        if (this.empty) {
            return false;
        }
        if (SpellGrid.exists(this.leftmost + side.offx, this.topmost + side.offy) && SpellGrid.exists(this.rightmost + side.offx, this.bottommost + side.offy)) {
            if (!doit) {
                return true;
            }
            SpellPiece[][] newGrid = new SpellPiece[9][9];
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    SpellPiece p = this.gridData[i][j];
                    if (p == null) continue;
                    int newX = i + side.offx;
                    int newY = j + side.offy;
                    newGrid[newX][newY] = p;
                    p.x = newX;
                    p.y = newY;
                }
            }
            this.gridData = newGrid;
            return true;
        }
        return false;
    }

    public static boolean exists(int x, int y) {
        return x >= 0 && y >= 0 && x < 9 && y < 9;
    }

    private SpellPiece getPieceAtSide(Multimap<SpellPiece, SpellParam.Side> traversed, int x, int y, SpellParam.Side side) throws SpellCompilationException {
        SpellPiece atSide = this.getPieceAtSideSafely(x, y, side);
        if (!traversed.put((Object)atSide, (Object)side)) {
            throw new SpellCompilationException("psi.spellerror.loop");
        }
        return atSide;
    }

    @Deprecated
    public SpellPiece getPieceAtSideWithRedirections(List<SpellPiece> unused, int x, int y, SpellParam.Side side) throws SpellCompilationException {
        return this.getPieceAtSideWithRedirections(x, y, side);
    }

    public SpellPiece getPieceAtSideWithRedirections(int x, int y, SpellParam.Side side) throws SpellCompilationException {
        return this.getPieceAtSideWithRedirections(x, y, side, (SpellPiece piece) -> {});
    }

    public SpellPiece getPieceAtSideWithRedirections(int x, int y, SpellParam.Side side, SpellPieceConsumer walker) throws SpellCompilationException {
        SpellPiece atSide;
        HashMultimap traversed = HashMultimap.create();
        while ((atSide = this.getPieceAtSide((Multimap<SpellPiece, SpellParam.Side>)traversed, x, y, side)) instanceof IGenericRedirector) {
            IGenericRedirector redirector = (IGenericRedirector)((Object)atSide);
            walker.accept(atSide);
            SpellParam.Side rside = redirector.remapSide(side);
            if (rside.isEnabled()) continue;
            return null;
        }
        return atSide;
    }

    public SpellPiece getPieceAtSideSafely(int x, int y, SpellParam.Side side) {
        int xp = x + side.offx;
        int yp = y + side.offy;
        if (!SpellGrid.exists(xp, yp)) {
            return null;
        }
        return this.gridData[xp][yp];
    }

    public SpellGrid(Spell spell) {
        this.spell = spell;
        this.gridData = new SpellPiece[9][9];
    }

    public boolean isEmpty() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece piece = this.gridData[i][j];
                if (piece == null) continue;
                return false;
            }
        }
        return true;
    }

    public void readFromNBT(CompoundNBT cmp) {
        this.gridData = new SpellPiece[9][9];
        ListNBT list = cmp.func_150295_c(TAG_SPELL_LIST, 10);
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            int posY;
            int posX;
            CompoundNBT lcmp = list.func_150305_b(i);
            if (lcmp.func_74764_b(TAG_SPELL_POS_X_LEGACY)) {
                posX = lcmp.func_74762_e(TAG_SPELL_POS_X_LEGACY);
                posY = lcmp.func_74762_e(TAG_SPELL_POS_Y_LEGACY);
            } else {
                posX = lcmp.func_74762_e(TAG_SPELL_POS_X);
                posY = lcmp.func_74762_e(TAG_SPELL_POS_Y);
            }
            CompoundNBT data = lcmp.func_74764_b(TAG_SPELL_DATA_LEGACY) ? lcmp.func_74775_l(TAG_SPELL_DATA_LEGACY) : lcmp.func_74775_l(TAG_SPELL_DATA);
            SpellPiece piece = SpellPiece.createFromNBT(this.spell, data);
            if (piece == null) continue;
            this.gridData[posX][posY] = piece;
            piece.isInGrid = true;
            piece.x = posX;
            piece.y = posY;
        }
    }

    public void writeToNBT(CompoundNBT cmp) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece piece = this.gridData[i][j];
                if (piece == null) continue;
                CompoundNBT lcmp = new CompoundNBT();
                lcmp.func_74768_a(TAG_SPELL_POS_X, i);
                lcmp.func_74768_a(TAG_SPELL_POS_Y, j);
                CompoundNBT data = new CompoundNBT();
                piece.writeToNBT(data);
                lcmp.func_218657_a(TAG_SPELL_DATA, (INBT)data);
                list.add((Object)lcmp);
            }
        }
        cmp.func_218657_a(TAG_SPELL_LIST, (INBT)list);
    }

    @FunctionalInterface
    public static interface SpellPieceConsumer {
        public void accept(SpellPiece var1) throws SpellCompilationException;
    }
}

