/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.cad;

import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.spell.ISpellAcceptor;

public interface ISocketable {
    public static final int MAX_SLOTS = 12;

    public static ITextComponent getSocketedItemName(ItemStack stack, String fallbackKey) {
        if (stack.func_190926_b() || !ISocketable.isSocketable(stack)) {
            return new TranslationTextComponent(fallbackKey);
        }
        ISocketable socketable = ISocketable.socketable(stack);
        ItemStack item = socketable.getSelectedBullet();
        if (item.func_190926_b()) {
            return new TranslationTextComponent(fallbackKey);
        }
        return item.func_200301_q();
    }

    public static boolean isSocketable(ItemStack stack) {
        return !stack.func_190926_b() && stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).isPresent();
    }

    public static ISocketable socketable(ItemStack stack) {
        return (ISocketable)stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    public boolean isSocketSlotAvailable(int var1);

    default public boolean showSlotInRadialMenu(int slot) {
        return this.isSocketSlotAvailable(slot);
    }

    public ItemStack getBulletInSocket(int var1);

    public void setBulletInSocket(int var1, ItemStack var2);

    public int getSelectedSlot();

    public void setSelectedSlot(int var1);

    default public ItemStack getSelectedBullet() {
        return this.getBulletInSocket(this.getSelectedSlot());
    }

    default public boolean isItemValid(int slot, ItemStack bullet) {
        if (!this.isSocketSlotAvailable(slot)) {
            return false;
        }
        if (bullet.func_190926_b()) {
            return false;
        }
        ISpellAcceptor container = ISpellAcceptor.acceptor(bullet);
        return this instanceof ICADData || !container.isCADOnlyContainer();
    }

    default public boolean canLoopcast() {
        return this instanceof ICADData;
    }
}

