/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.impl.tag.extension.TagDelegate;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.TriPredicate;
import vazkii.patchouli.common.multiblock.StateMatcher;

public class StringStateMatcher {
    public static IStateMatcher fromString(String s) throws CommandSyntaxException {
        if ((s = s.trim()).equals("ANY")) {
            return StateMatcher.ANY;
        }
        if (s.equals("AIR")) {
            return StateMatcher.AIR;
        }
        class_2259 parser = new class_2259(new StringReader(s), true).method_9678(false);
        class_2680 state = parser.method_9669();
        if (state != null) {
            return new ExactMatcher(state, parser.method_9692());
        }
        TagDelegate tag = new TagDelegate(Objects.requireNonNull(parser.method_9664()), class_3481::method_15073);
        return new TagMatcher((class_3494.class_5123)tag, parser.method_9688());
    }

    private static class TagMatcher
    implements IStateMatcher {
        private final class_3494.class_5123<class_2248> tag;
        private final Map<String, String> props;

        private TagMatcher(class_3494.class_5123<class_2248> tag, Map<String, String> props) {
            this.tag = tag;
            this.props = props;
        }

        @Override
        public class_2680 getDisplayedState(int ticks) {
            ArrayList all = new ArrayList(this.tag.method_15138());
            if (all.isEmpty()) {
                return class_2246.field_9987.method_9564();
            }
            int idx = ticks / 20 % all.size();
            return ((class_2248)all.get(idx)).method_9564();
        }

        @Override
        public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
            return (w, p, s) -> this.tag.method_15141((Object)s.method_26204()) && this.checkProps((class_2680)s);
        }

        private boolean checkProps(class_2680 state) {
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                class_2769 prop = state.method_26204().method_9595().method_11663(entry.getKey());
                if (prop == null) {
                    return false;
                }
                Comparable value = prop.method_11900(entry.getValue()).orElse(null);
                if (value == null) {
                    return false;
                }
                if (state.method_11654(prop).equals(value)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagMatcher that = (TagMatcher)o;
            return Objects.equals(this.tag.method_26791(), that.tag.method_26791()) && Objects.equals(this.props, that.props);
        }

        public int hashCode() {
            return Objects.hash(this.tag.method_26791(), this.props);
        }
    }

    private static class ExactMatcher
    implements IStateMatcher {
        private final class_2680 state;
        private final Map<class_2769<?>, Comparable<?>> props;

        private ExactMatcher(class_2680 state, Map<class_2769<?>, Comparable<?>> props) {
            this.state = state;
            this.props = props;
        }

        @Override
        public class_2680 getDisplayedState(int ticks) {
            return this.state;
        }

        @Override
        public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
            return (w, p, s) -> this.state.method_26204() == s.method_26204() && this.checkProps((class_2680)s);
        }

        private boolean checkProps(class_2680 state) {
            for (Map.Entry<class_2769<?>, Comparable<?>> e : this.props.entrySet()) {
                if (state.method_11654(e.getKey()).equals(e.getValue())) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExactMatcher that = (ExactMatcher)o;
            return Objects.equals(this.state, that.state) && Objects.equals(this.props, that.props);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.props);
        }
    }
}

