package vazkii.patchouli.common.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import org.apache.commons.lang3.tuple.Pair;

import vazkii.patchouli.common.base.Patchouli;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;

public class EntityUtil {

	public static String getEntityName(String entityId) {
		Pair<String, String> nameAndNbt = splitNameAndNBT(entityId);
		class_1299<?> type = class_2378.field_11145.method_10223(new class_2960(nameAndNbt.getLeft()));

		return type.method_5882();
	}

	public static Function<class_1937, class_1297> loadEntity(String entityId) {
		Pair<String, String> nameAndNbt = splitNameAndNBT(entityId);
		entityId = nameAndNbt.getLeft();
		String nbtStr = nameAndNbt.getRight();
		class_2487 nbt = null;

		if (!nbtStr.isEmpty()) {
			try {
				nbt = class_2522.method_10718(nbtStr);
			} catch (CommandSyntaxException e) {
				Patchouli.LOGGER.error("Failed to load entity data", e);
			}
		}

		class_2960 key = new class_2960(entityId);
		Optional<class_1299<?>> maybeType = class_2378.field_11145.method_17966(key);
		if (!maybeType.isPresent()) {
			throw new RuntimeException("Unknown entity id: " + entityId);
		}
		class_1299<?> type = maybeType.get();
		final class_2487 useNbt = nbt;
		final String useId = entityId;
		return (world) -> {
			class_1297 entity;
			try {
				entity = type.method_5883(world);
				if (useNbt != null) {
					entity.method_5651(useNbt);
				}

				return entity;
			} catch (Exception e) {
				throw new IllegalArgumentException("Can't load entity " + useId, e);
			}
		};
	}

	private static Pair<String, String> splitNameAndNBT(String entityId) {
		int nbtStart = entityId.indexOf("{");
		String nbtStr = "";
		if (nbtStart > 0) {
			nbtStr = entityId.substring(nbtStart).replaceAll("([^\\\\])'", "$1\"").replaceAll("\\\\'", "'");
			entityId = entityId.substring(0, nbtStart);
		}

		return Pair.of(entityId, nbtStr);
	}

}
