package vazkii.patchouli.common.multiblock;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;

import net.fabricmc.fabric.impl.tag.extension.TagDelegate;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.TriPredicate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StringStateMatcher {
	public static IStateMatcher fromString(String s) throws CommandSyntaxException {
		s = s.trim();
		if (s.equals("ANY")) {
			return StateMatcher.ANY;
		}
		if (s.equals("AIR")) {
			return StateMatcher.AIR;
		}

		// c.f. BlockPredicateArgumentType. Similar, but doesn't use vanilla's weird caching class.
		class_2259 parser = new class_2259(new StringReader(s), true).method_9678(false);
		class_2680 state = parser.method_9669();

		if (state != null) {
			return new ExactMatcher(state, parser.method_9692());
		} else {
			class_3494.class_5123<class_2248> tag = new TagDelegate<>(Objects.requireNonNull(parser.method_9664()), class_3481::method_15073);
			return new TagMatcher(tag, parser.method_9688());
		}
	}

	private static class ExactMatcher implements IStateMatcher {
		private final class_2680 state;
		private final Map<class_2769<?>, Comparable<?>> props;

		private ExactMatcher(class_2680 state, Map<class_2769<?>, Comparable<?>> props) {
			this.state = state;
			this.props = props;
		}

		@Override
		public class_2680 getDisplayedState(int ticks) {
			return state;
		}

		@Override
		public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
			return (w, p, s) -> state.method_26204() == s.method_26204() && checkProps(s);
		}

		private boolean checkProps(class_2680 state) {
			for (Map.Entry<class_2769<?>, Comparable<?>> e : props.entrySet()) {
				if (!state.method_11654(e.getKey()).equals(e.getValue())) {
					return false;
				}
			}
			return true;
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) {
				return true;
			}
			if (o == null || getClass() != o.getClass()) {
				return false;
			}
			ExactMatcher that = (ExactMatcher) o;
			return Objects.equals(state, that.state) &&
					Objects.equals(props, that.props);
		}

		@Override
		public int hashCode() {
			return Objects.hash(state, props);
		}
	}

	private static class TagMatcher implements IStateMatcher {
		private final class_3494.class_5123<class_2248> tag;
		private final Map<String, String> props;

		private TagMatcher(class_3494.class_5123<class_2248> tag, Map<String, String> props) {
			this.tag = tag;
			this.props = props;
		}

		@Override
		public class_2680 getDisplayedState(int ticks) {
			List<class_2248> all = new ArrayList<>(tag.method_15138());
			if (all.isEmpty()) {
				return class_2246.field_9987.method_9564(); // show something impossible
			} else {
				int idx = (ticks / 20) % all.size();
				return all.get(idx).method_9564();
			}
		}

		@Override
		public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
			return (w, p, s) -> tag.method_15141(s.method_26204()) && checkProps(s);
		}

		private boolean checkProps(class_2680 state) {
			for (Map.Entry<String, String> entry : props.entrySet()) {
				class_2769<?> prop = state.method_26204().method_9595().method_11663(entry.getKey());
				if (prop == null) {
					return false;
				}

				Comparable<?> value = prop.method_11900(entry.getValue()).orElse(null);
				if (value == null) {
					return false;
				}

				if (!state.method_11654(prop).equals(value)) {
					return false;
				}
			}
			return true;
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) {
				return true;
			}
			if (o == null || getClass() != o.getClass()) {
				return false;
			}
			TagMatcher that = (TagMatcher) o;
			return Objects.equals(tag.method_26791(), that.tag.method_26791()) &&
					Objects.equals(props, that.props);
		}

		@Override
		public int hashCode() {
			return Objects.hash(tag.method_26791(), props);
		}
	}
}
