package vazkii.patchouli.common.multiblock;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.common.util.RotationUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;

public class SparseMultiblock extends AbstractMultiblock {
	private final Map<class_2338, IStateMatcher> data;
	private final class_2382 size;

	public SparseMultiblock(Map<class_2338, IStateMatcher> data) {
		Preconditions.checkArgument(!data.isEmpty(), "No data given to sparse multiblock!");
		this.data = ImmutableMap.copyOf(data);
		this.size = calculateSize();
	}

	@Override
	public class_2382 getSize() {
		return size;
	}

	private class_2382 calculateSize() {
		int minX = data.keySet().stream().mapToInt(class_2338::method_10263).min().getAsInt();
		int maxX = data.keySet().stream().mapToInt(class_2338::method_10263).max().getAsInt();
		int minY = data.keySet().stream().mapToInt(class_2338::method_10264).min().getAsInt();
		int maxY = data.keySet().stream().mapToInt(class_2338::method_10264).max().getAsInt();
		int minZ = data.keySet().stream().mapToInt(class_2338::method_10260).min().getAsInt();
		int maxZ = data.keySet().stream().mapToInt(class_2338::method_10260).max().getAsInt();
		return new class_2382(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
	}

	@Override
	public class_2680 method_8320(class_2338 pos) {
		int ticks = world != null ? (int) world.method_8532() : 0;
		return data.getOrDefault(pos, StateMatcher.AIR).getDisplayedState(ticks);
	}

	@Override
	public Pair<class_2338, Collection<SimulateResult>> simulate(class_1937 world, class_2338 anchor, class_2470 rotation, boolean forView) {
		class_2338 disp = forView
				? new class_2338(-viewOffX, -viewOffY + 1, -viewOffZ).method_10070(rotation)
				: new class_2338(-offX, -offY, -offZ).method_10070(rotation);
		// the local origin of this multiblock, in world coordinates
		class_2338 origin = anchor.method_10081(disp);
		List<SimulateResult> ret = new ArrayList<>();
		for (Map.Entry<class_2338, IStateMatcher> e : data.entrySet()) {
			class_2338 currDisp = e.getKey().method_10070(rotation);
			class_2338 actionPos = origin.method_10081(currDisp);
			ret.add(new SimulateResultImpl(actionPos, e.getValue(), null));
		}
		return Pair.of(origin, ret);
	}

	@Override
	public boolean test(class_1937 world, class_2338 start, int x, int y, int z, class_2470 rotation) {
		setWorld(world);
		class_2338 checkPos = start.method_10081(new class_2338(x, y, z).method_10070(rotation));
		class_2680 state = world.method_8320(checkPos).method_26186(RotationUtil.fixHorizontal(rotation));
		IStateMatcher matcher = data.getOrDefault(new class_2338(x, y, z), StateMatcher.ANY);
		return matcher.getStatePredicate().test(world, checkPos, state);
	}
}
