package vazkii.patchouli.common.base;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import org.apache.commons.io.IOUtils;

import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI.IPatchouliAPI;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.multiblock.DenseMultiblock;
import vazkii.patchouli.common.multiblock.MultiblockRegistry;
import vazkii.patchouli.common.multiblock.SparseMultiblock;
import vazkii.patchouli.common.multiblock.StateMatcher;
import vazkii.patchouli.common.network.message.MessageOpenBookGui;
import vazkii.patchouli.common.util.ItemStackUtil;

import javax.annotation.Nonnull;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class PatchouliAPIImpl implements IPatchouliAPI {

	public static final PatchouliAPIImpl INSTANCE = new PatchouliAPIImpl();

	private PatchouliAPIImpl() {}

	@Override
	public boolean isStub() {
		return false;
	}

	@Override
	public void setConfigFlag(String flag, boolean value) {
		PatchouliConfig.setFlag(flag, value);
	}

	@Override
	public boolean getConfigFlag(String flag) {
		return PatchouliConfig.getConfigFlag(flag);
	}

	@Override
	public void openBookGUI(class_3222 player, class_2960 book) {
		MessageOpenBookGui.send(player, book, null, 0);
	}

	@Override
	public void openBookEntry(class_3222 player, class_2960 book, class_2960 entry, int page) {
		MessageOpenBookGui.send(player, book, entry, page);
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void openBookGUI(class_2960 book) {
		ClientBookRegistry.INSTANCE.displayBookGui(book, null, 0);
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void openBookEntry(class_2960 book, class_2960 entry, int page) {
		ClientBookRegistry.INSTANCE.displayBookGui(book, entry, page);
	}

	@Override
	@Environment(EnvType.CLIENT)
	public class_2960 getOpenBookGui() {
		class_437 gui = class_310.method_1551().field_1755;
		if (gui instanceof GuiBook) {
			return ((GuiBook) gui).book.id;
		}
		return null;
	}

	@Nonnull
	@Override
	public class_2561 getSubtitle(@Nonnull class_2960 bookId) {
		Book book = BookRegistry.INSTANCE.books.get(bookId);
		if (book == null) {
			throw new IllegalArgumentException("Book not found: " + bookId);
		}
		return book.getSubtitle();
	}

	@Override
	public void reloadBookContents() {
		Patchouli.reloadBookHandler.run();
	}

	@Override
	public class_1799 getBookStack(class_2960 book) {
		return ItemModBook.forBook(book);
	}

	@Override
	public void registerTemplateAsBuiltin(class_2960 res, Supplier<InputStream> streamProvider) {
		InputStream testStream = streamProvider.get();
		if (testStream == null) {
			throw new NullPointerException("Stream provider can't return a null stream");
		}
		IOUtils.closeQuietly(testStream);

		Supplier<BookTemplate> prev = BookContents.addonTemplates.put(res, () -> {
			InputStream stream = streamProvider.get();
			InputStreamReader reader = new InputStreamReader(stream);
			return ClientBookRegistry.INSTANCE.gson.fromJson(reader, BookTemplate.class);
		});

		if (prev != null) {
			throw new IllegalArgumentException("Template " + res + " is already registered");
		}
	}

	@Override
	public class_1799 deserializeItemStack(String str) {
		return ItemStackUtil.loadStackFromString(str);
	}

	@Override
	public String serializeItemStack(class_1799 stack) {
		return ItemStackUtil.serializeStack(stack);
	}

	@Override
	public List<class_1799> deserializeItemStackList(String str) {
		return ItemStackUtil.loadStackListFromString(str);
	}

	@Override
	public String serializeItemStackList(List<class_1799> stacks) {
		return ItemStackUtil.serializeStackList(stacks);
	}

	@Override
	public class_1856 deserializeIngredient(String str) {
		return ItemStackUtil.loadIngredientFromString(str);
	}

	@Override
	public String serializeIngredient(class_1856 ingredient) {
		return ItemStackUtil.serializeIngredient(ingredient);
	}

	@Override
	public IMultiblock getMultiblock(class_2960 res) {
		return MultiblockRegistry.MULTIBLOCKS.get(res);
	}

	@Override
	public IMultiblock registerMultiblock(class_2960 res, IMultiblock mb) {
		return MultiblockRegistry.registerMultiblock(res, mb);
	}

	@Override
	@Environment(EnvType.CLIENT)
	public IMultiblock getCurrentMultiblock() {
		return MultiblockVisualizationHandler.hasMultiblock ? MultiblockVisualizationHandler.getMultiblock() : null;
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void showMultiblock(@Nonnull IMultiblock multiblock, @Nonnull class_2561 displayName, @Nonnull class_2338 center, @Nonnull class_2470 rotation) {
		MultiblockVisualizationHandler.setMultiblock(multiblock, displayName, null, false);
		MultiblockVisualizationHandler.anchorTo(center, rotation);
	}

	@Override
	public void clearMultiblock() {
		MultiblockVisualizationHandler.setMultiblock(null, (class_2561) null, null, false);
	}

	@Override
	public IMultiblock makeMultiblock(String[][] pattern, Object... targets) {
		return new DenseMultiblock(pattern, targets);
	}

	@Override
	public IMultiblock makeSparseMultiblock(Map<class_2338, IStateMatcher> positions) {
		return new SparseMultiblock(positions);
	}

	@Override
	public IStateMatcher predicateMatcher(class_2680 display, Predicate<class_2680> predicate) {
		return StateMatcher.fromPredicate(display, predicate);
	}

	@Override
	public IStateMatcher predicateMatcher(class_2248 display, Predicate<class_2680> predicate) {
		return StateMatcher.fromPredicate(display, predicate);
	}

	@Override
	public IStateMatcher stateMatcher(class_2680 state) {
		return StateMatcher.fromState(state);
	}

	@Override
	public IStateMatcher propertyMatcher(class_2680 state, class_2769<?>... properties) {
		return StateMatcher.fromStateWithFilter(state, Arrays.asList(properties)::contains);
	}

	@Override
	public IStateMatcher looseBlockMatcher(class_2248 block) {
		return StateMatcher.fromBlockLoose(block);
	}

	@Override
	public IStateMatcher strictBlockMatcher(class_2248 block) {
		return StateMatcher.fromBlockStrict(block);
	}

	@Override
	public IStateMatcher displayOnlyMatcher(class_2680 state) {
		return StateMatcher.displayOnly(state);
	}

	@Override
	public IStateMatcher displayOnlyMatcher(class_2248 block) {
		return StateMatcher.displayOnly(block);
	}

	@Override
	public IStateMatcher airMatcher() {
		return StateMatcher.AIR;
	}

	@Override
	public IStateMatcher anyMatcher() {
		return StateMatcher.ANY;
	}

}
