package vazkii.patchouli.client.shader;

import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_281;
import net.minecraft.class_284;
import net.minecraft.class_285;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3679;
import net.minecraft.class_4013;
import vazkii.patchouli.common.base.Patchouli;

import java.io.IOException;

public class ShaderHelper implements class_4013, IdentifiableResourceReloadListener {
	public static final ShaderHelper INSTANCE = new ShaderHelper();
	public static final class_2960 ID = new class_2960(Patchouli.MOD_ID, "shaders");

	private ShaderHelper() {}

	public class_3679 alpha = null;
	public class_284 alphaUniform = null;

	private void cleanup() {
		if (alpha != null) {
			class_285.method_1304(alpha);
			alpha = null;
		}
		if (alphaUniform != null) {
			alphaUniform.close();
			alphaUniform = null;
		}
	}

	@Override
	public void method_14491(class_3300 manager) {
		cleanup();
		alpha = loadProgram(manager, "alpha");
		alphaUniform = new class_284("alpha", 4 /* one float */, 1, alpha);
		alphaUniform.method_1297(class_284.method_22096(alpha.method_1270(), "alpha"));
	}

	private static class_3679 loadProgram(class_3300 manager, String name) {
		class_2960 vertPath = new class_2960(Patchouli.MOD_ID, "shaders/" + name + ".vsh");
		class_2960 fragPath = new class_2960(Patchouli.MOD_ID, "shaders/" + name + ".fsh");
		try (class_3298 vert = manager.method_14486(vertPath);
				class_3298 frag = manager.method_14486(fragPath)) {
			class_281 vertShader = class_281.method_1283(class_281.class_282.field_1530, vertPath.toString(), vert.method_14482());
			class_281 fragShader = class_281.method_1283(class_281.class_282.field_1531, fragPath.toString(), frag.method_14482());
			class_3679 prog = new Program(class_285.method_1306(), vertShader, fragShader);
			class_285.method_1307(prog);
			return prog;
		} catch (IOException ex) {
			Patchouli.LOGGER.error("Shader error", ex);
			return null;
		}
	}

	@Override
	public class_2960 getFabricId() {
		return ID;
	}

	private static class Program implements class_3679 {
		private final int program;
		private final class_281 vert;
		private final class_281 frag;

		private Program(int program, class_281 vert, class_281 frag) {
			this.program = program;
			this.vert = vert;
			this.frag = frag;
		}

		@Override
		public int method_1270() {
			return program;
		}

		@Override
		public void method_1279() {

		}

		@Override
		public class_281 method_1274() {
			return vert;
		}

		@Override
		public class_281 method_1278() {
			return frag;
		}
	}
}
