package vazkii.patchouli.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1799;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import vazkii.patchouli.client.RenderHelper;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;

public class GuiButtonInventoryBook extends class_4185 {

	private Book book;

	public GuiButtonInventoryBook(Book book, int x, int y) {
		super(x, y, 20, 20, class_2585.field_24366, (b) -> {
			BookContents contents = book.contents;
			contents.openLexiconGui(contents.getCurrentGui(), false);
		});
		this.book = book;
	}

	@Override
	public void method_25359(class_4587 ms, int mouseX, int mouseY, float pticks) {
		class_310 mc = class_310.method_1551();
		mc.method_1531().method_22813(new class_2960(Patchouli.MOD_ID, "textures/gui/inventory_button.png"));
		RenderSystem.color3f(1F, 1F, 1F);

		boolean hovered = mouseX >= field_22760 && mouseY >= field_22761 && mouseX < field_22760 + field_22758 && mouseY < field_22761 + field_22759;
		class_332.method_25290(ms, field_22760, field_22761, (hovered ? 20 : 0), 0, field_22758, field_22759, 64, 64);

		class_1799 stack = book.getBookItem();
		RenderHelper.renderItemStackInGui(ms, stack, field_22760 + 2, field_22761 + 2);

		EntryDisplayState readState = book.contents.getReadState();
		if (readState.hasIcon && readState.showInInventory) {
			GuiBook.drawMarking(ms, book, field_22760, field_22761, 0, readState);
		}
	}

	public Book getBook() {
		return book;
	}

}
