package vazkii.patchouli.client.book.text;

import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.book.Book;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class SpanState {
	public final GuiBook gui;
	public final Book book;

	private final class_2583 baseStyle;
	private final Deque<class_2583> styleStack = new ArrayDeque<>();
	public class_5250 tooltip = BookTextParser.EMPTY_STRING_COMPONENT;
	public Supplier<Boolean> onClick = null;
	public List<Span> cluster = null;
	public boolean isExternalLink = false; // will show the "external link" symbol next to the link as soon as the link is closed
	public boolean endingExternal = false; // will show the "external link" symbol next to the link immediately
	public int lineBreaks = 0; // force line breaks
	public int spacingLeft = 0; // add extra spacing
	public int spacingRight = 0;

	public SpanState(GuiBook gui, Book book, class_2583 baseStyle) {
		this.gui = gui;
		this.book = book;
		this.baseStyle = baseStyle;
		this.styleStack.push(baseStyle);
	}

	public String color(class_5251 color) {
		return modifyStyle(s -> s.method_27703(color));
	}

	public String baseColor() {
		return color(baseStyle.method_10973());
	}

	public String modifyStyle(Function<class_2583, class_2583> f) {
		class_2583 top = styleStack.pop();
		styleStack.push(f.apply(top));
		return "";
	}

	public void pushStyle(class_2583 style) {
		class_2583 top = styleStack.peek();
		styleStack.push(style.method_27702(top));
	}

	public class_2583 popStyle() {
		class_2583 ret = styleStack.pop();
		if (styleStack.isEmpty()) {
			throw new IllegalStateException("Underflow in style stack");
		}
		return ret;
	}

	public void reset() {
		endingExternal = isExternalLink;
		styleStack.clear();
		styleStack.push(baseStyle);
		cluster = null;
		tooltip = BookTextParser.EMPTY_STRING_COMPONENT;
		onClick = null;
		isExternalLink = false;
	}

	public class_2583 peekStyle() {
		return styleStack.getFirst();
	}
}
