package vazkii.patchouli.client.book.text;

import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_5250;
import net.minecraft.text.*;
import java.util.List;
import java.util.function.Supplier;

/**
 * An associated span of textual data that shares the same style.
 * A {@code Span} does not know its positioning.
 * At this point, all macros should have been expanded.
 */
public class Span {
	public static Span error(SpanState state, String message) {
		return new Span(state, message, class_2583.field_24360.method_10977(class_124.field_1061));
	}

	public final String text;
	public final class_2583 style;
	public final List<Span> linkCluster;
	public final class_2561 tooltip;
	public final Supplier<Boolean> onClick;
	public final int lineBreaks;
	public final int spacingLeft;
	public final int spacingRight;
	public final boolean bold;

	public Span(SpanState state, String text) {
		this.text = text;
		this.style = state.peekStyle();
		this.onClick = state.onClick;
		this.linkCluster = state.cluster;
		this.tooltip = state.tooltip;
		this.lineBreaks = state.lineBreaks;
		this.spacingLeft = state.spacingLeft;
		this.spacingRight = state.spacingRight;
		this.bold = style.method_10984();

		state.lineBreaks = 0;
		state.spacingLeft = 0;
		state.spacingRight = 0;
	}

	private Span(SpanState state, String text, class_2583 style) {
		this.text = text;
		this.style = style;
		this.onClick = null;
		this.linkCluster = null;
		this.tooltip = new class_2585("");
		this.lineBreaks = state.lineBreaks;
		this.spacingLeft = state.spacingLeft;
		this.spacingRight = state.spacingRight;
		this.bold = style.method_10984();

		state.lineBreaks = 0;
		state.spacingLeft = 0;
		state.spacingRight = 0;
	}

	public class_5250 styledSubstring(int start) {
		return new class_2585(text.substring(start)).method_10862(style);
	}

	public class_5250 styledSubstring(int start, int end) {
		return new class_2585(text.substring(start, end)).method_10862(style);
	}
}
