package vazkii.patchouli.client.book.template.component;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.template.TemplateComponent;

import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class ComponentImage extends TemplateComponent {

	public String image;

	public int u, v, width, height;

	@SerializedName("texture_width") public int textureWidth = 256;
	@SerializedName("texture_height") public int textureHeight = 256;

	public float scale = 1F;

	transient class_2960 resource;

	@Override
	public void build(BookPage page, BookEntry entry, int pageNum) {
		if (image.contains(":")) {
			resource = new class_2960(image);
		} else {
			resource = new class_2960(page.book.getModNamespace(), image);
		}
	}

	@Override
	public void onVariablesAvailable(Function<String, String> lookup) {
		super.onVariablesAvailable(lookup);
		image = lookup.apply(image);
	}

	@Override
	public void render(class_4587 ms, BookPage page, int mouseX, int mouseY, float pticks) {
		if (scale == 0F) {
			return;
		}

		page.mc.method_1531().method_22813(resource);
		ms.method_22903();
		ms.method_22904(x, y, 0);
		ms.method_22905(scale, scale, scale);
		RenderSystem.color4f(1F, 1F, 1F, 1F);
		RenderSystem.enableBlend();
		class_332.method_25290(ms, 0, 0, u, v, width, height, textureWidth, textureHeight);
		ms.method_22909();
	}

}
