package vazkii.patchouli.client.book.page.abstr;

import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.mixin.MixinRecipeManager;

import javax.annotation.Nullable;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import java.util.Map;

public abstract class PageDoubleRecipeRegistry<T extends class_1860<?>> extends PageDoubleRecipe<T> {
	private final class_3956<T> recipeType;

	public PageDoubleRecipeRegistry(class_3956<T> recipeType) {
		this.recipeType = recipeType;
	}

	@Nullable
	private T getRecipe(class_2960 id) {
		class_1863 manager = class_310.method_1551().field_1687.method_8433();
		Map<class_2960, T> recipes = (Map<class_2960, T>) ((MixinRecipeManager) manager).callGetAllOfType(recipeType);
		return recipes.get(id);
	}

	@Override
	protected T loadRecipe(BookEntry entry, class_2960 res) {
		if (res == null) {
			return null;
		}

		T tempRecipe = getRecipe(res);
		if (tempRecipe == null) { // this is hacky but it works around Forge requiring custom recipes to have the prefix of the adding mod
			tempRecipe = getRecipe(new class_2960("crafttweaker", res.method_12832()));
		}

		if (tempRecipe != null) {
			entry.addRelevantStack(tempRecipe.method_8110(), pageNum);
			return tempRecipe;
		}

		return null;
	}

}
