package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.util.ItemStackUtil;

public class PageSpotlight extends PageWithText {

	String item, title;
	@SerializedName("link_recipe") boolean linkRecipe;

	transient class_1799 itemStack;

	@Override
	public void build(BookEntry entry, int pageNum) {
		itemStack = ItemStackUtil.loadStackFromString(item);

		if (linkRecipe) {
			entry.addRelevantStack(itemStack, pageNum);
		}
	}

	@Override
	public void render(class_4587 ms, int mouseX, int mouseY, float pticks) {
		int w = 66;
		int h = 26;

		mc.method_1531().method_22813(book.craftingTexture);
		RenderSystem.enableBlend();
		class_332.method_25290(ms, GuiBook.PAGE_WIDTH / 2 - w / 2, 10, 0, 128 - h, w, h, 128, 128);

		class_2561 toDraw;
		if (title != null && !title.isEmpty()) {
			toDraw = i18nText(title);
		} else {
			toDraw = itemStack.method_7964();
		}

		parent.drawCenteredStringNoShadow(ms, toDraw, GuiBook.PAGE_WIDTH / 2, 0, book.headerColor);
		parent.renderItemStack(ms, GuiBook.PAGE_WIDTH / 2 - 8, 15, mouseX, mouseY, itemStack);

		super.render(ms, mouseX, mouseY, pticks);
	}

	@Override
	public int getTextHeight() {
		return 40;
	}

}
