package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.base.PersistentData.DataHolder.BookData.Bookmark;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookEye;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.client.mixin.MixinBlockEntity;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.MultiblockRegistry;
import vazkii.patchouli.common.multiblock.SerializedMultiblock;

import javax.annotation.Nonnull;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_824;
import net.minecraft.class_827;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;

public class PageMultiblock extends PageWithText {
	private static final Random RAND = new Random();

	String name = "";
	@SerializedName("multiblock_id") class_2960 multiblockId;

	@SerializedName("multiblock") SerializedMultiblock serializedMultiblock;

	@SerializedName("enable_visualize") boolean showVisualizeButton = true;

	private transient AbstractMultiblock multiblockObj;
	private transient class_4185 visualizeButton;

	@Override
	public void build(BookEntry entry, int pageNum) {
		if (multiblockId != null) {
			IMultiblock mb = MultiblockRegistry.MULTIBLOCKS.get(multiblockId);

			if (mb instanceof AbstractMultiblock) {
				multiblockObj = (AbstractMultiblock) mb;
			}
		}

		if (multiblockObj == null && serializedMultiblock != null) {
			multiblockObj = serializedMultiblock.toMultiblock();
		}

		if (multiblockObj == null) {
			throw new IllegalArgumentException("No multiblock located for " + multiblockId);
		}
	}

	@Override
	public void onDisplayed(GuiBookEntry parent, int left, int top) {
		super.onDisplayed(parent, left, top);

		if (showVisualizeButton) {
			addButton(visualizeButton = new GuiButtonBookEye(parent, 12, 97, this::handleButtonVisualize));
		}
	}

	@Override
	public int getTextHeight() {
		return 115;
	}

	@Override
	public void render(class_4587 ms, int mouseX, int mouseY, float pticks) {
		int x = GuiBook.PAGE_WIDTH / 2 - 53;
		int y = 7;
		RenderSystem.enableBlend();
		RenderSystem.color3f(1F, 1F, 1F);
		GuiBook.drawFromTexture(ms, book, x, y, 405, 149, 106, 106);

		parent.drawCenteredStringNoShadow(ms, name, GuiBook.PAGE_WIDTH / 2, 0, book.headerColor);

		if (multiblockObj != null) {
			renderMultiblock(ms);
		}

		super.render(ms, mouseX, mouseY, pticks);
	}

	public void handleButtonVisualize(class_4185 button) {
		String entryKey = parent.getEntry().getId().toString();
		Bookmark bookmark = new Bookmark(entryKey, pageNum / 2);
		MultiblockVisualizationHandler.setMultiblock(multiblockObj, new class_2585(name), bookmark, true);
		parent.addBookmarkButtons();

		if (!PersistentData.data.clickedVisualize) {
			PersistentData.data.clickedVisualize = true;
			PersistentData.save();
		}
	}

	private void renderMultiblock(class_4587 ms) {
		multiblockObj.setWorld(mc.field_1687);
		class_2382 size = multiblockObj.getSize();
		int sizeX = size.method_10263();
		int sizeY = size.method_10264();
		int sizeZ = size.method_10260();
		float maxX = 90;
		float maxY = 90;
		float diag = (float) Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
		float scaleX = maxX / diag;
		float scaleY = maxY / sizeY;
		float scale = -Math.min(scaleX, scaleY);

		int xPos = GuiBook.PAGE_WIDTH / 2;
		int yPos = 60;
		ms.method_22903();
		ms.method_22904(xPos, yPos, 100);
		ms.method_22905(scale, scale, scale);
		ms.method_22904(-(float) sizeX / 2, -(float) sizeY / 2, 0);

		// Initial eye pos somewhere off in the distance in the -Z direction
		class_1162 eye = new class_1162(0, 0, -100, 1);
		class_1159 rotMat = new class_1159();
		rotMat.method_22668();

		// For each GL rotation done, track the opposite to keep the eye pos accurate
		ms.method_22907(class_1160.field_20703.method_23214(-30F));
		rotMat.method_22670(class_1160.field_20703.method_23214(30));

		float offX = (float) -sizeX / 2;
		float offZ = (float) -sizeZ / 2 + 1;

		float time = parent.ticksInBook * 0.5F;
		if (!class_437.method_25442()) {
			time += ClientTicker.partialTicks;
		}
		ms.method_22904(-offX, 0, -offZ);
		ms.method_22907(class_1160.field_20705.method_23214(time));
		rotMat.method_22670(class_1160.field_20705.method_23214(-time));
		ms.method_22907(class_1160.field_20705.method_23214(45));
		rotMat.method_22670(class_1160.field_20705.method_23214(-45));
		ms.method_22904(offX, 0, offZ);

		// Finally apply the rotations
		eye.method_22674(rotMat);
		eye.method_23219();
		/* TODO XXX This does not handle visualization of sparse multiblocks correctly.
			Dense multiblocks store everything in positive X/Z, so this works, but sparse multiblocks store everything from the JSON as-is.
			Potential solution: Rotate around the offset vars of the multiblock, and add AABB method for extent of the multiblock
		*/
		renderElements(ms, multiblockObj, class_2338.method_10097(class_2338.field_10980, new class_2338(sizeX - 1, sizeY - 1, sizeZ - 1)), eye);

		ms.method_22909();
	}

	private void renderElements(class_4587 ms, AbstractMultiblock mb, Iterable<? extends class_2338> blocks, class_1162 eye) {
		ms.method_22903();
		RenderSystem.color4f(1F, 1F, 1F, 1F);
		ms.method_22904(0, 0, -1);

		class_4597.class_4598 buffers = class_310.method_1551().method_22940().method_23000();
		doWorldRenderPass(ms, mb, blocks, buffers, eye);
		doTileEntityRenderPass(ms, mb, blocks, buffers, eye);

		// todo 1.15 transparency sorting
		buffers.method_22993();
		ms.method_22909();
	}

	private void doWorldRenderPass(class_4587 ms, AbstractMultiblock mb, Iterable<? extends class_2338> blocks, final @Nonnull class_4597.class_4598 buffers, class_1162 eye) {
		for (class_2338 pos : blocks) {
			class_2680 bs = mb.method_8320(pos);
			class_4588 buffer = buffers.getBuffer(class_4696.method_23679(bs));

			ms.method_22903();
			ms.method_22904(pos.method_10263(), pos.method_10264(), pos.method_10260());
			class_310.method_1551().method_1541().method_3355(bs, pos, mb, ms, buffer, false, RAND);
			ms.method_22909();
		}
	}

	// Hold errored TEs weakly, this may cause some dupe errors but will prevent spamming it every frame
	private final transient Set<class_2586> erroredTiles = Collections.newSetFromMap(new WeakHashMap<>());

	private void doTileEntityRenderPass(class_4587 ms, AbstractMultiblock mb, Iterable<? extends class_2338> blocks, class_4597 buffers, class_1162 eye) {
		for (class_2338 pos : blocks) {
			class_2586 te = mb.method_8321(pos);
			if (te != null && !erroredTiles.contains(te)) {
				te.method_11009(mc.field_1687, pos);

				// fake cached state in case the renderer checks it as we don't want to query the actual world
				((MixinBlockEntity) te).setCachedState(mb.method_8320(pos));

				ms.method_22903();
				ms.method_22904(pos.method_10263(), pos.method_10264(), pos.method_10260());
				try {
					class_827<class_2586> renderer = class_824.field_4346.method_3550(te);
					if (renderer != null) {
						renderer.method_3569(te, ClientTicker.partialTicks, ms, buffers, 0xF000F0, class_4608.field_21444);
					}
				} catch (Exception e) {
					erroredTiles.add(te);
					Patchouli.LOGGER.error("An exception occured rendering tile entity", e);
				} finally {
					ms.method_22909();
				}
			}
		}
	}
}
