package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.util.EntityUtil;

import java.util.function.Function;
import net.minecraft.class_1074;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_898;

public class PageEntity extends PageWithText {

	@SerializedName("entity") public String entityId;

	float scale = 1F;
	@SerializedName("offset") float extraOffset = 0F;
	String name;

	boolean rotate = true;
	@SerializedName("default_rotation") float defaultRotation = -45f;

	transient boolean errored;
	transient class_1297 entity;
	transient Function<class_1937, class_1297> creator;
	transient float renderScale, offset;

	@Override
	public void build(BookEntry entry, int pageNum) {
		super.build(entry, pageNum);

		creator = EntityUtil.loadEntity(entityId);
	}

	@Override
	public void onDisplayed(GuiBookEntry parent, int left, int top) {
		super.onDisplayed(parent, left, top);

		loadEntity(parent.getMinecraft().field_1687);
	}

	@Override
	public int getTextHeight() {
		return 115;
	}

	@Override
	public void render(class_4587 ms, int mouseX, int mouseY, float pticks) {
		int x = GuiBook.PAGE_WIDTH / 2 - 53;
		int y = 7;
		RenderSystem.enableBlend();
		RenderSystem.color3f(1F, 1F, 1F);
		GuiBook.drawFromTexture(ms, book, x, y, 405, 149, 106, 106);

		if (name == null || name.isEmpty()) {
			if (entity != null) {
				parent.drawCenteredStringNoShadow(ms, entity.method_5477(), GuiBook.PAGE_WIDTH / 2, 0, book.headerColor);
			}
		} else {
			parent.drawCenteredStringNoShadow(ms, name, GuiBook.PAGE_WIDTH / 2, 0, book.headerColor);
		}

		if (errored) {
			fontRenderer.method_1720(ms, class_1074.method_4662("patchouli.gui.lexicon.loading_error"), 58, 60, 0xFF0000);
		}

		if (entity != null) {
			float rotation = rotate ? ClientTicker.total : defaultRotation;
			renderEntity(ms, entity, parent.getMinecraft().field_1687, 58, 60, rotation, renderScale, offset);
		}

		super.render(ms, mouseX, mouseY, pticks);
	}

	public static void renderEntity(class_4587 ms, class_1297 entity, class_1937 world, float x, float y, float rotation, float renderScale, float offset) {
		entity.field_6002 = world;

		ms.method_22903();
		ms.method_22904(x, y, 50);
		ms.method_22905(renderScale, renderScale, renderScale);
		ms.method_22904(0, offset, 0);
		ms.method_22907(class_1160.field_20707.method_23214(180));
		ms.method_22907(class_1160.field_20705.method_23214(rotation));
		class_898 erd = class_310.method_1551().method_1561();
		class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
		erd.method_3948(false);
		erd.method_3954(entity, 0, 0, 0, 0, 1, ms, immediate, 0xF000F0);
		erd.method_3948(true);
		immediate.method_22993();
		ms.method_22909();
	}

	private void loadEntity(class_1937 world) {
		if (!errored && (entity == null || !entity.method_5805())) {
			try {
				entity = creator.apply(world);

				float width = entity.method_17681();
				float height = entity.method_17682();

				float entitySize = width;
				if (width < height) {
					entitySize = height;
				}
				entitySize = Math.max(1F, entitySize);

				renderScale = 100F / entitySize * 0.8F * scale;
				offset = Math.max(height, entitySize) * 0.5F + extraOffset;
			} catch (Exception e) {
				errored = true;
				Patchouli.LOGGER.error("Failed to load entity", e);
			}
		}
	}

}
