package vazkii.patchouli.client.book.page;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2588;
import net.minecraft.class_332;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4587;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipeRegistry;

public class PageCrafting extends PageDoubleRecipeRegistry<class_3955> {

	public PageCrafting() {
		super(class_3956.field_17545);
	}

	@Override
	protected void drawRecipe(class_4587 ms, class_3955 recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
		mc.method_1531().method_22813(book.craftingTexture);
		RenderSystem.enableBlend();
		class_332.method_25290(ms, recipeX - 2, recipeY - 2, 0, 0, 100, 62, 128, 128);

		boolean shaped = recipe instanceof class_1869;
		if (!shaped) {
			int iconX = recipeX + 62;
			int iconY = recipeY + 2;
			class_332.method_25290(ms, iconX, iconY, 0, 64, 11, 11, 128, 128);
			if (parent.isMouseInRelativeRange(mouseX, mouseY, iconX, iconY, 11, 11)) {
				parent.setTooltip(new class_2588("patchouli.gui.lexicon.shapeless"));
			}
		}

		parent.drawCenteredStringNoShadow(ms, getTitle(second), GuiBook.PAGE_WIDTH / 2, recipeY - 10, book.headerColor);

		parent.renderItemStack(ms, recipeX + 79, recipeY + 22, mouseX, mouseY, recipe.method_8110());

		class_2371<class_1856> ingredients = recipe.method_8117();
		int wrap = 3;
		if (shaped) {
			wrap = ((class_1869) recipe).method_8150();
		}

		for (int i = 0; i < ingredients.size(); i++) {
			parent.renderIngredient(ms, recipeX + (i % wrap) * 19 + 3, recipeY + (i / wrap) * 19 + 3, mouseX, mouseY, ingredients.get(i));
		}
	}

	@Override
	protected int getRecipeHeight() {
		return 78;
	}

	@Override
	protected class_1799 getRecipeOutput(class_3955 recipe) {
		if (recipe == null) {
			return class_1799.field_8037;
		}

		return recipe.method_8110();
	}

}
