package vazkii.patchouli.client.book.gui;

import net.minecraft.class_1074;
import net.minecraft.class_2585;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookResize;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;

public class GuiBookWriter extends GuiBook {

	BookTextRenderer text, editableText;
	class_342 textfield;

	private static String savedText = "";
	private static boolean drawHeader;

	public GuiBookWriter(Book book) {
		super(book, class_2585.field_24366);
	}

	@Override
	public void method_25426() {
		super.method_25426();

		text = new BookTextRenderer(this, class_1074.method_4662("patchouli.gui.lexicon.editor.info"), LEFT_PAGE_X, TOP_PADDING + 20);
		textfield = new class_342(field_22793, 10, FULL_HEIGHT - 40, PAGE_WIDTH, 20, class_2585.field_24366);
		textfield.method_1880(Integer.MAX_VALUE);
		textfield.method_1852(savedText);

		method_25411(new GuiButtonBookResize(this, bookLeft + 115, bookTop + PAGE_HEIGHT - 36, false, this::handleButtonResize));
		refreshText();
	}

	@Override
	void drawForegroundElements(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
		super.drawForegroundElements(ms, mouseX, mouseY, partialTicks);

		drawCenteredStringNoShadow(ms, class_1074.method_4662("patchouli.gui.lexicon.editor"), LEFT_PAGE_X + PAGE_WIDTH / 2, TOP_PADDING, book.headerColor);
		drawSeparator(ms, book, LEFT_PAGE_X, TOP_PADDING + 12);

		if (drawHeader) {
			drawCenteredStringNoShadow(ms, class_1074.method_4662("patchouli.gui.lexicon.editor.mock_header"), RIGHT_PAGE_X + PAGE_WIDTH / 2, TOP_PADDING, book.headerColor);
			drawSeparator(ms, book, RIGHT_PAGE_X, TOP_PADDING + 12);
		}

		textfield.method_25394(ms, mouseX, mouseY, partialTicks);
		text.render(ms, mouseX, mouseY);
		editableText.render(ms, mouseX, mouseY);
	}

	@Override
	public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
		return textfield.method_25402(getRelativeX(mouseX), getRelativeY(mouseY), mouseButton)
				|| text.click(mouseX, mouseY, mouseButton)
				|| editableText.click(mouseX, mouseY, mouseButton)
				|| super.mouseClickedScaled(mouseX, mouseY, mouseButton);
	}

	@Override
	public boolean method_25404(int key, int scanCode, int modifiers) {
		if (textfield.method_25404(key, scanCode, modifiers)) {
			refreshText();
			return true;
		}

		return super.method_25404(key, scanCode, modifiers);
	}

	@Override
	public boolean method_25400(char c, int i) {
		if (textfield.method_25400(c, i)) {
			refreshText();
			return true;
		}

		return super.method_25400(c, i);
	}

	public void handleButtonResize(class_4185 button) {
		drawHeader = !drawHeader;
		refreshText();
	}

	public void refreshText() {
		int yPos = TOP_PADDING + (drawHeader ? 22 : -4);

		savedText = textfield.method_1882();
		try {
			editableText = new BookTextRenderer(this, savedText, RIGHT_PAGE_X, yPos);
		} catch (Throwable e) {
			editableText = new BookTextRenderer(this, "[ERROR]", RIGHT_PAGE_X, yPos);
			Patchouli.LOGGER.catching(e);
		}
	}
}
