package vazkii.patchouli.client.book.gui;

import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.base.PersistentData.DataHolder.BookData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;

import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class GuiBookHistory extends GuiBookEntryList {

	public GuiBookHistory(Book book) {
		super(book, new class_2588("patchouli.gui.lexicon.history"));
	}

	@Override
	protected String getDescriptionText() {
		return class_1074.method_4662("patchouli.gui.lexicon.history.info");
	}

	@Override
	protected boolean shouldDrawProgressBar() {
		return false;
	}

	@Override
	protected boolean shouldSortEntryList() {
		return false;
	}

	@Override
	protected Collection<BookEntry> getEntries() {
		BookData data = PersistentData.data.getBookData(book);

		return data.history.stream()
				.map(class_2960::new)
				.map((res) -> book.contents.entries.get(res))
				.filter((e) -> e != null && !e.isLocked())
				.collect(Collectors.toList());
	}

}
