package vazkii.patchouli.client.book.gui;

import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

import java.util.*;
import net.minecraft.class_310;
import net.minecraft.class_4185;

public class GuiBookCategory extends GuiBookEntryList {

	BookCategory category;

	public GuiBookCategory(Book book, BookCategory category) {
		super(book, category.getName());
		this.category = category;
	}

	@Override
	protected String getDescriptionText() {
		return category.getDescription();
	}

	@Override
	protected Collection<BookEntry> getEntries() {
		return category.getEntries();
	}

	@Override
	protected void addSubcategoryButtons() {
		int i = 0;
		List<BookCategory> categories = new ArrayList<>(book.contents.categories.values());
		Collections.sort(categories);

		for (BookCategory ocategory : categories) {
			if (ocategory.getParentCategory() != category || ocategory.shouldHide()) {
				continue;
			}

			int x = LEFT_PAGE_X + 10 + (i % 4) * 24;
			int y = TOP_PADDING + PAGE_HEIGHT - (PatchouliConfig.disableAdvancementLocking.getValue() ? 46 : 68);

			class_4185 button = new GuiButtonCategory(this, x, y, ocategory, this::handleButtonCategory);
			method_25411(button);
			dependentButtons.add(button);

			i++;
		}
	}

	@Override
	protected boolean doesEntryCountForProgress(BookEntry entry) {
		return entry.getCategory() == category;
	}

	@Override
	public boolean equals(Object obj) {
		return obj == this || (obj instanceof GuiBookCategory && ((GuiBookCategory) obj).category == category && ((GuiBookCategory) obj).spread == spread);
	}

	@Override
	public int hashCode() {
		return Objects.hashCode(category) * 31 + Objects.hashCode(spread);
	}

	@Override
	public boolean canBeOpened() {
		return !category.isLocked() && !equals(class_310.method_1551().field_1755);
	}

}
