package vazkii.patchouli.client.book.gui;

import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.Word;
import vazkii.patchouli.common.book.Book;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5251;

public class BookTextRenderer {
	private final Book book;
	private final GuiBook gui;
	private final String text;
	private final int x, y, width;
	private final int lineHeight;
	private final class_2583 baseStyle;

	private List<Word> words;

	public BookTextRenderer(GuiBook gui, String text, int x, int y) {
		this(gui, text, x, y, GuiBook.PAGE_WIDTH, GuiBook.TEXT_LINE_HEIGHT, gui.book.textColor);
	}

	public BookTextRenderer(GuiBook gui, String text, int x, int y, int width, int lineHeight, int baseColor) {
		this.book = gui.book;
		this.gui = gui;
		if (book.i18n) {
			this.text = class_1074.method_4662(text);
		} else {
			this.text = text;
		}
		this.x = x;
		this.y = y;
		this.width = width;
		this.lineHeight = lineHeight;
		this.baseStyle = book.getFontStyle().method_27703(class_5251.method_27717(baseColor));

		build();
	}

	private void build() {
		BookTextParser parser = new BookTextParser(gui, book, x, y, width, lineHeight, baseStyle);
		words = parser.parse(text);
	}

	public void render(class_4587 ms, int mouseX, int mouseY) {
		class_327 font = class_310.method_1551().field_1772;
		class_2583 style = book.getFontStyle();
		words.forEach(word -> word.render(ms, font, style, mouseX, mouseY));
	}

	public boolean click(double mouseX, double mouseY, int mouseButton) {
		for (Word word : words) {
			if (word.click(mouseX, mouseY, mouseButton)) {
				return true;
			}
		}

		return false;
	}
}
