package vazkii.patchouli.client.book;

import com.google.gson.JsonObject;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public abstract class BookPage {

	public transient class_310 mc;
	public transient class_327 fontRenderer;
	public transient GuiBookEntry parent;

	public transient Book book;
	protected transient BookEntry entry;
	protected transient int pageNum;
	private transient List<class_4185> buttons;
	public transient int left, top;
	public transient JsonObject sourceObject;

	protected String type, flag, advancement, anchor;

	public void build(BookEntry entry, int pageNum) {
		this.book = entry.getBook();
		this.entry = entry;
		this.pageNum = pageNum;
	}

	public void onDisplayed(GuiBookEntry parent, int left, int top) {
		mc = parent.getMinecraft();
		book = parent.book;
		fontRenderer = mc.field_1772;
		this.parent = parent;
		this.left = left;
		this.top = top;
		buttons = new ArrayList<>();
	}

	public boolean isPageUnlocked() {
		return advancement == null || advancement.isEmpty() || ClientAdvancements.hasDone(advancement);
	}

	public void onHidden(GuiBookEntry parent) {
		parent.removeButtonsIn(buttons);
	}

	protected void addButton(class_4185 button) {
		button.field_22760 += (parent.bookLeft + left);
		button.field_22761 += (parent.bookTop + top);
		buttons.add(button);
		parent.method_25411(button);
	}

	public void render(class_4587 ms, int mouseX, int mouseY, float pticks) {}

	public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
		return false;
	}

	public boolean canAdd(Book book) {
		return flag == null || flag.isEmpty() || PatchouliConfig.getConfigFlag(flag);
	}

	public String i18n(String text) {
		return book.i18n ? class_1074.method_4662(text) : text;
	}

	public class_2561 i18nText(String text) {
		return book.i18n ? new class_2588(text) : new class_2585(text);
	}
}
