package vazkii.patchouli.client.base;

import com.mojang.blaze3d.systems.RenderSystem;
import vazkii.patchouli.client.RenderHelper;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.mixin.MixinClientAdvancementManagerAccessor;
import vazkii.patchouli.common.book.Book;

import javax.annotation.Nonnull;
import net.minecraft.class_1074;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4587;
import net.minecraft.class_632;
import net.minecraft.class_634;
import java.util.Map;

public class ClientAdvancements {
	private static boolean gotFirstAdvPacket = false;

	/* Hooked at the end of ClientAdvancementManager.read, when the advancement packet arrives clientside
	The initial book load is done here when the first advancement packet arrives.
	Doing it anytime before that leads to excessive toast spam because the book believes everything to be locked,
	and then the first advancement packet unlocks everything.
	*/
	public static void onClientPacket() {
		if (!gotFirstAdvPacket) {
			ClientBookRegistry.INSTANCE.reload();
			gotFirstAdvPacket = true;
		} else {
			ClientBookRegistry.INSTANCE.reloadLocks(false);
		}
	}

	public static boolean hasDone(String advancement) {
		class_2960 id = class_2960.method_12829(advancement);
		if (id != null) {
			class_634 conn = class_310.method_1551().method_1562();
			if (conn != null) {
				class_632 cm = conn.method_2869();
				class_161 adv = cm.method_2863().method_716(id);
				if (adv != null) {
					Map<class_161, class_167> progressMap = ((MixinClientAdvancementManagerAccessor) cm).getAdvancementProgresses();
					class_167 progress = progressMap.get(adv);
					return progress != null && progress.method_740();
				}
			}
		}
		return false;
	}

	public static void playerLogout() {
		gotFirstAdvPacket = false;
	}

	public static void sendBookToast(Book book) {
		class_374 gui = class_310.method_1551().method_1566();
		if (gui.method_1997(LexiconToast.class, book) == null) {
			gui.method_1999(new LexiconToast(book));
		}
	}

	public static class LexiconToast implements class_368 {
		private final Book book;

		public LexiconToast(Book book) {
			this.book = book;
		}

		@Nonnull
		@Override
		public Book getType() {
			return book;
		}

		@Nonnull
		@Override
		public class_369 method_1986(class_4587 ms, class_374 toastGui, long delta) {
			class_310 mc = class_310.method_1551();
			mc.method_1531().method_22813(field_2207);
			RenderSystem.color3f(1.0F, 1.0F, 1.0F);
			toastGui.method_25302(ms, 0, 0, 0, 32, 160, 32);

			toastGui.method_1995().field_1772.method_1729(ms, class_1074.method_4662(book.name), 30, 7, -11534256);
			toastGui.method_1995().field_1772.method_1729(ms, class_1074.method_4662("patchouli.gui.lexicon.toast.info"), 30, 17, -16777216);

			RenderHelper.renderItemStackInGui(ms, book.getBookItem(), 8, 8);

			return delta >= 5000L ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
		}

	}

}
