package vazkii.patchouli.api;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import vazkii.patchouli.api.stub.StubPatchouliAPI;

import javax.annotation.Nullable;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class PatchouliAPI {

	/**
	 * This is loaded by Patchouli to be a proper one at mod construction time.<br>
	 * Note that books are initialized by patchouli on in common setup, but contents are not loaded until
	 * the client logs in to a world.
	 */
	public static IPatchouliAPI instance = StubPatchouliAPI.INSTANCE;

	public interface IPatchouliAPI {

		// ================================================================================================
		// API
		// ================================================================================================

		/**
		 * Returns false if this is a real API class loaded by the actual mod.
		 */
		boolean isStub();

		// ================================================================================================
		// Book and Templates
		// ================================================================================================

		/**
		 * Sets a config flag to the value passed.<br>
		 * IMPORTANT: DO NOT call this without your flag being prefixed with your
		 * mod id. There is no protection against that, but don't be a jerk.
		 */
		void setConfigFlag(String flag, boolean value);

		/**
		 * Gets the value of a config flag, or false if it doesn't have a value.
		 */
		boolean getConfigFlag(String flag);

		/**
		 * Opens the given book to the last page that was open, or the landing page otherwise.
		 */
		void openBookGUI(class_3222 player, class_2960 book);

		/**
		 * Opens the book to the given entry
		 */
		void openBookEntry(class_3222 player, class_2960 book, class_2960 entry, int page);

		/**
		 * Client version of {@link #openBookGUI(ServerPlayerEntity, Identifier)}.
		 */
		void openBookGUI(class_2960 book);

		/**
		 * Client version of {@link #openBookEntry(ServerPlayerEntity, Identifier, Identifier, int)}
		 */
		void openBookEntry(class_2960 book, class_2960 entry, int page);

		class_2960 getOpenBookGui();

		/**
		 * @return                          The subtitle (edition string/what appears under the title in the landing
		 *                                  page) of the book.
		 * @throws IllegalArgumentException if the book id given cannot be found
		 */
		class_2561 getSubtitle(class_2960 bookId);

		/**
		 * Reloads the contents of all books. Call sparingly and only if you
		 * really need it for whatever reason.
		 */
		void reloadBookContents();

		/**
		 * Returns a book item with its NBT set to the book passed in.
		 */
		class_1799 getBookStack(class_2960 book);

		/**
		 * Register a template you made as a built in template to be used with all books
		 * as the "res" resource location. The supplier should give an input stream that
		 * reads a full json file, containing a template.
		 */
		@Environment(EnvType.CLIENT)
		void registerTemplateAsBuiltin(class_2960 res, Supplier<InputStream> streamProvider);

		// ================================================================================================
		// ItemStack Serialization
		// ================================================================================================

		/**
		 * Deserializes a stack string into its ItemStack.
		 */
		class_1799 deserializeItemStack(String str);

		/**
		 * Serializes an ItemStack into its string correspondent.
		 */
		String serializeItemStack(class_1799 stack);

		/**
		 * Serializes an ingredient string into a list of ItemStacks.
		 */
		List<class_1799> deserializeItemStackList(String str);

		/**
		 * Serializes a list of ItemStacks into its string correspondent.
		 */
		String serializeItemStackList(List<class_1799> stacks);

		// ================================================================================================
		// Ingredient Serialization
		// ================================================================================================

		/**
		 * Deserializes an ingredient string into its Ingredient.
		 */
		class_1856 deserializeIngredient(String str);

		/**
		 * Serializes an Ingredient into its string correspondent.
		 */
		String serializeIngredient(class_1856 ingredient);

		// ================================================================================================
		// Multiblocks
		// ================================================================================================

		/**
		 * Gets a multiblock by its resource location, or null if none exists for it.
		 */
		IMultiblock getMultiblock(class_2960 res);

		/**
		 * Registers a multiblock given its resource location. This takes care of both registering it
		 * and setting its resource location to the one passed.
		 */
		IMultiblock registerMultiblock(class_2960 res, IMultiblock mb);

		/**
		 * @return The multiblock currently being visualized in-world or null if no multiblock is visualized. Only works
		 *         clientside.
		 */
		@Nullable
		IMultiblock getCurrentMultiblock();

		/**
		 * Sets the given multiblock as the currently visualized one. This overwrites any currently visualized
		 * multiblock.
		 * Only works clientside.
		 * 
		 * @param multiblock  The multiblock to visualize
		 * @param displayName The name to show above the completion bar
		 * @param center      Where to place the multiblock's center
		 * @param rotation    Orientation to visualize
		 */
		void showMultiblock(IMultiblock multiblock, class_2561 displayName, class_2338 center, class_2470 rotation);

		/**
		 * Clears the currently visualized multiblock. Only works clientside.
		 */
		void clearMultiblock();

		/**
		 * Creates a multiblock given the pattern and targets given. This works in the same way as
		 * recipe registrations do, except it's a 2D array. The pattern works in the same way as
		 * you'd register a multiblock using JSON. Check the page on Multiblocks on the Patchouli
		 * wiki for more info.
		 * <br>
		 * <br>
		 * As for the target array, it's in also in the same format as recipes. One char followed
		 * by one Object, so on and so forth, defining each type. The Object can be a Block, an
		 * BlockState, or an IStateMatcher.
		 */
		IMultiblock makeMultiblock(String[][] pattern, Object... targets);

		/**
		 * Create a sparse multiblock. This is useful in situations where the multiblock is large and unwieldy
		 * to specify in a 2D grid. The center of a sparse multiblock is always (0, 0, 0), and the keys
		 * of {@code positions} are relative to that space.
		 */
		IMultiblock makeSparseMultiblock(Map<class_2338, IStateMatcher> positions);

		/**
		 * Gets an IStateMatcher with the passed in BlockState for display and the passed in
		 * predicate for validation.
		 */
		IStateMatcher predicateMatcher(class_2680 display, Predicate<class_2680> predicate);

		/**
		 * Gets an IStateMatcher with the passed in Block's default state for display and the
		 * passed in predicate for validation.
		 */
		IStateMatcher predicateMatcher(class_2248 display, Predicate<class_2680> predicate);

		/**
		 * Gets an IStateMatcher with the passed in BlockState for display and validation,
		 * requiring that the state in world be exactly the same.
		 */
		IStateMatcher stateMatcher(class_2680 state);

		/**
		 * Gets an IStateMatcher with the passed in BlockState for display and validation,
		 * requiring that only the specified properties are the same.
		 */
		IStateMatcher propertyMatcher(class_2680 state, class_2769<?>... properties);

		/**
		 * Gets an IStateMatcher with the passed in Block's default state for display and
		 * validation, requiring that the state in world have only the same block.
		 */
		IStateMatcher looseBlockMatcher(class_2248 block);

		/**
		 * Gets an IStateMatcher with the passed in Block's default state for display and
		 * validation, requiring that the state in world be exactly the same.
		 */
		IStateMatcher strictBlockMatcher(class_2248 block);

		/**
		 * Gets an IStateMatcher that always validates to true, and shows the BlockState
		 * passed when displayed.
		 */
		IStateMatcher displayOnlyMatcher(class_2680 state);

		/**
		 * Gets an IStateMatcher that always validates to true, and shows the passed in
		 * Block's default state when displayed.
		 */
		IStateMatcher displayOnlyMatcher(class_2248 block);

		/**
		 * Gets an IStateMatcher that accepts only air blocks.
		 */
		IStateMatcher airMatcher();

		/**
		 * Gets an IStateMatcher that accepts anything.
		 */
		IStateMatcher anyMatcher();
	}

}
