/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.base;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.api.PatchouliConfigAccess;
import vazkii.patchouli.xplat.IXplatAbstractions;
import vazkii.patchouli.xplat.XplatModContainer;

public class PatchouliConfig {
    private static final Map<String, Boolean> CONFIG_FLAGS = new ConcurrentHashMap<String, Boolean>();
    private static PatchouliConfigAccess access = null;

    public static PatchouliConfigAccess get() {
        return access;
    }

    public static void set(PatchouliConfigAccess a) {
        if (access != null) {
            throw new IllegalStateException("ConfigAccess already set");
        }
        access = a;
    }

    public static void reloadBuiltinFlags() {
        Collection<XplatModContainer> mods = IXplatAbstractions.INSTANCE.getAllMods();
        for (XplatModContainer info : mods) {
            PatchouliConfig.setFlag("mod:" + info.getId(), true);
        }
        PatchouliConfig.setFlag("debug", IXplatAbstractions.INSTANCE.isDevEnvironment());
        PatchouliConfig.setFlag("advancements_disabled", PatchouliConfig.get().disableAdvancementLocking());
        PatchouliConfig.setFlag("testing_mode", PatchouliConfig.get().testingMode());
        for (String book : PatchouliConfig.get().noAdvancementBooks()) {
            PatchouliConfig.setFlag("advancements_disabled_" + book, true);
        }
    }

    public static boolean getConfigFlag(String name) {
        Boolean b;
        if (name.startsWith("&")) {
            return PatchouliConfig.getConfigFlagAND(name.replaceAll("[&|]", "").split(","));
        }
        if (name.startsWith("|")) {
            return PatchouliConfig.getConfigFlagOR(name.replaceAll("[&|]", "").split(","));
        }
        boolean target = true;
        if (name.startsWith("!")) {
            name = name.substring(1);
            target = false;
        }
        if ((b = CONFIG_FLAGS.get(name = name.trim().toLowerCase(Locale.ROOT))) == null) {
            if (!name.startsWith("mod:")) {
                PatchouliAPI.LOGGER.warn("Queried for unknown config flag: {}", (Object)name);
            }
            b = false;
        }
        return b == target;
    }

    public static boolean getConfigFlagAND(String[] tokens) {
        for (String s : tokens) {
            if (PatchouliConfig.getConfigFlag(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean getConfigFlagOR(String[] tokens) {
        for (String s : tokens) {
            if (!PatchouliConfig.getConfigFlag(s)) continue;
            return true;
        }
        return false;
    }

    public static void setFlag(String flag, boolean value) {
        CONFIG_FLAGS.put(flag.trim().toLowerCase(Locale.ROOT), value);
    }
}

