package vazkii.patchouli.fabric.network;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.network.MessageReloadBookContents;

public class FabricMessageReloadBookContents {

	public static void sendToAll(MinecraftServer server) {
		PlayerLookup.all(server).forEach(FabricMessageReloadBookContents::send);
	}

	public static void send(class_3222 player) {
		ServerPlayNetworking.send(player, new MessageReloadBookContents());
	}

	public static void handle(MessageReloadBookContents message, ClientPlayNetworking.Context handler) {
		class_310 client = handler.client();
		client.method_20493(() -> ClientBookRegistry.INSTANCE.reload());
	}
}
