package vazkii.patchouli.common.util;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.JsonOps;
import org.apache.commons.lang3.tuple.Triple;

import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2291;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.class_9326;

public final class ItemStackUtil {
	private ItemStackUtil() {}

	public static Triple<class_6880<class_1792>, class_9326, Integer> deserializeStack(String string, class_7225.class_7874 registries) {
		StringReader reader = new StringReader(string.trim());
		class_2291 itemParser = new class_2291(registries);
		try {
			class_2291.class_7215 result = itemParser.method_9789(reader);
			int count = 1;
			if (reader.canRead()) {
				reader.expect('#');
				count = reader.readInt();
			}
			return Triple.of(result.comp_628(), result.comp_2439(), count);
		} catch (CommandSyntaxException e) {
			throw new RuntimeException(e);
		}
	}

	public static class_1799 loadFromParsed(Triple<class_6880<class_1792>, class_9326, Integer> parsed) {
		var holder = parsed.getLeft();
		var components = parsed.getMiddle();
		var count = parsed.getRight();
		if (!holder.method_40227() && holder.method_40230().isPresent()) {
			throw new RuntimeException("Unknown item ID: " + holder.method_40230().get().method_29177());
		}
		class_1792 item = holder.comp_349();
		class_1799 stack = new class_1799(item, count);

		if (!components.method_57848()) {
			stack.method_57366(components);
		}
		return stack;
	}

	public static class_1799 loadStackFromString(String res, class_7225.class_7874 registries) {
		return loadFromParsed(deserializeStack(res, registries));
	}

	public static class_1856 loadIngredientFromString(String ingredientString, class_7225.class_7874 registries) {
		return class_1856.method_8101(loadStackListFromString(ingredientString, registries).toArray(new class_1799[0]));
	}

	public static List<class_1799> loadStackListFromString(String ingredientString, class_7225.class_7874 registries) {
		String[] stacksSerialized = splitStacksFromSerializedIngredient(ingredientString);
		List<class_1799> stacks = new ArrayList<>();
		for (String s : stacksSerialized) {
			if (s.isEmpty())
				continue;
			if (s.startsWith("tag:")) {
				var key = class_6862.method_40092(class_7924.field_41197, class_2960.method_12829(s.substring(4)));
				registries.method_46762(class_7924.field_41197).method_46733(key).stream().flatMap(class_6885::method_40239).forEach(item -> stacks.add(new class_1799(item)));
			} else {
				stacks.add(loadStackFromString(s, registries));
			}
		}
		return stacks;
	}

	public static StackWrapper wrapStack(class_1799 stack) {
		return stack.method_7960() ? StackWrapper.EMPTY_WRAPPER : new StackWrapper(stack);
	}

	@Nullable
	public static Book getBookFromStack(class_1799 stack) {
		if (stack.method_7909() instanceof ItemModBook) {
			return ItemModBook.getBook(stack);
		}

		Collection<Book> books = BookRegistry.INSTANCE.books.values();
		for (Book b : books) {
			if (class_1799.method_7984(b.getBookItem(), stack)) {
				return b;
			}
		}

		return null;
	}

	public static class StackWrapper {

		public static final StackWrapper EMPTY_WRAPPER = new StackWrapper(class_1799.field_8037);

		public final class_1799 stack;

		public StackWrapper(class_1799 stack) {
			this.stack = stack;
		}

		@Override
		public boolean equals(Object obj) {
			return obj == this || (obj instanceof StackWrapper && class_1799.method_7984(stack, ((StackWrapper) obj).stack));
		}

		@Override
		public int hashCode() {
			return stack.method_7909().hashCode();
		}

		@Override
		public String toString() {
			return "Wrapper[" + stack.toString() + "]";
		}

	}

	private static String[] splitStacksFromSerializedIngredient(String ingredientSerialized) {
		final List<String> result = new ArrayList<>();

		int lastIndex = 0;
		int braces = 0;
		int brackets = 0;
		Character insideString = null;
		for (int i = 0; i < ingredientSerialized.length(); i++) {
			switch (ingredientSerialized.charAt(i)) {
			case '{':
				if (insideString == null) {
					braces++;
				}
				break;
			case '}':
				if (insideString == null) {
					braces--;
				}
				break;
			case '[':
				if (insideString == null) {
					brackets++;
				}
				break;
			case ']':
				if (insideString == null) {
					brackets--;
				}
				break;
			case '\'':
				insideString = insideString == null ? '\'' : null;
				break;
			case '"':
				insideString = insideString == null ? '"' : null;
				break;
			case ',':
				if (braces <= 0 && brackets <= 0) {
					result.add(ingredientSerialized.substring(lastIndex, i));
					lastIndex = i + 1;
					break;
				}
			}
		}

		result.add(ingredientSerialized.substring(lastIndex));

		return result.toArray(new String[0]);
	}

	public static class_1799 loadStackFromJson(JsonObject json, class_7225.class_7874 registries) {
		String itemName = json.get("item").getAsString();

		class_1792 item = class_7923.field_41178.method_17966(class_2960.method_12829(itemName)).orElseThrow(() -> new IllegalArgumentException("Unknown item '" + itemName + "'")
		);

		class_1799 stack = new class_1799(item, class_3518.method_15282(json, "count", 1));

		if (json.has("components")) {
			class_9323.field_50234.parse(registries.method_57093(JsonOps.INSTANCE), json.get("components")).result()
					.ifPresent(stack::method_57365);
		}

		return stack;
	}
}
