package vazkii.patchouli.common.multiblock;

import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.common.util.RotationUtil;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class SimulateResultImpl implements IMultiblock.SimulateResult {
	private final class_2338 worldPosition;
	private final IStateMatcher stateMatcher;
	@Nullable private final Character character;

	public SimulateResultImpl(class_2338 worldPosition, IStateMatcher stateMatcher, @Nullable Character character) {
		this.worldPosition = worldPosition;
		this.stateMatcher = stateMatcher;
		this.character = character;
	}

	@Override
	public class_2338 getWorldPosition() {
		return worldPosition;
	}

	@Override
	public IStateMatcher getStateMatcher() {
		return stateMatcher;
	}

	@Nullable
	@Override
	public Character getCharacter() {
		return character;
	}

	@Override
	public boolean test(class_1937 world, class_2470 rotation) {
		class_2680 state = world.method_8320(getWorldPosition()).method_26186(RotationUtil.fixHorizontal(rotation));
		return getStateMatcher().getStatePredicate().test(world, getWorldPosition(), state);
	}
}
