package vazkii.patchouli.client.book.page.abstr;

import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class PageDoubleRecipeRegistry<T extends class_1860<?>> extends PageDoubleRecipe<T> {
	private final class_3956<? extends T> recipeType;

	public PageDoubleRecipeRegistry(class_3956<? extends T> recipeType) {
		this.recipeType = recipeType;
	}

	@Nullable
	private T getRecipe(class_1937 level, class_2960 id) {
		class_1863 manager = level.method_8433();
		var recipeHolder = manager.method_8130(id).filter(recipe -> recipe.comp_1933().method_17716() == recipeType).orElse(null);
		return recipeHolder != null ? (T) recipeHolder.comp_1933() : null;
	}

	@Override
	protected T loadRecipe(class_1937 level, BookContentsBuilder builder, BookEntry entry, class_2960 res, boolean linkRecipe) {
		if (res == null || level == null) {
			return null;
		}

		T tempRecipe = getRecipe(level, res);
		if (tempRecipe == null) { // this is hacky but it works around Forge requiring custom recipes to have the prefix of the adding mod
			tempRecipe = getRecipe(level, class_2960.method_60655("crafttweaker", res.method_12832()));
		}

		if (tempRecipe != null) {
			if (linkRecipe) {
				entry.addRelevantStack(builder, tempRecipe.method_8110(level.method_30349()), pageNum);
			}
			return tempRecipe;
		}

		PatchouliAPI.LOGGER.warn("Recipe {} (of type {}) not found", res, class_7923.field_41188.method_10221(recipeType));
		return null;
	}

}
