package vazkii.patchouli.client.book.page;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3956;
import net.minecraft.class_8059;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import net.minecraft.world.item.crafting.*;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipeRegistry;
import vazkii.patchouli.mixin.AccessorSmithingTransformRecipe;
import vazkii.patchouli.mixin.AccessorSmithingTrimRecipe;

public class PageSmithing extends PageDoubleRecipeRegistry<class_8059> {

	public PageSmithing() {
		super(class_3956.field_25388);
	}

	@Override
	protected void drawRecipe(class_332 graphics, class_8059 recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
		class_1937 level = class_310.method_1551().field_1687;
		if (level == null) {
			return;
		}

		RenderSystem.enableBlend();
		graphics.method_25290(book.craftingTexture, recipeX, recipeY, 11, 135, 96, 43, 128, 256);
		parent.drawCenteredStringNoShadow(graphics, getTitle(second).method_30937(), GuiBook.PAGE_WIDTH / 2, recipeY - 10, book.headerColor);

		parent.renderIngredient(graphics, recipeX + 4, recipeY + 4, mouseX, mouseY, getBase(recipe));
		parent.renderIngredient(graphics, recipeX + 4, recipeY + 23, mouseX, mouseY, getAddition(recipe));
		parent.renderIngredient(graphics, recipeX + 40, recipeY + 4, mouseX, mouseY, getTemplate(recipe));
		parent.renderItemStack(graphics, recipeX + 40, recipeY + 20, mouseX, mouseY, recipe.method_17447());
		parent.renderItemStack(graphics, recipeX + 76, recipeY + 13, mouseX, mouseY, recipe.method_8110(level.method_30349()));
	}

	private class_1856 getBase(class_8059 recipe) {
		if (recipe instanceof class_8062) {
			return ((AccessorSmithingTrimRecipe) recipe).getBase();
		}
		if (recipe instanceof class_8060) {
			return ((AccessorSmithingTransformRecipe) recipe).getBase();
		}
		return class_1856.field_9017;
	}

	private class_1856 getAddition(class_8059 recipe) {
		if (recipe instanceof class_8062) {
			return ((AccessorSmithingTrimRecipe) recipe).getAddition();
		}
		if (recipe instanceof class_8060) {
			return ((AccessorSmithingTransformRecipe) recipe).getAddition();
		}
		return class_1856.field_9017;
	}

	private class_1856 getTemplate(class_8059 recipe) {
		if (recipe instanceof class_8062) {
			return ((AccessorSmithingTrimRecipe) recipe).getTemplate();
		}
		if (recipe instanceof class_8060) {
			return ((AccessorSmithingTransformRecipe) recipe).getTemplate();
		}
		return class_1856.field_9017;
	}

	@Override
	protected class_1799 getRecipeOutput(class_1937 level, class_8059 recipe) {
		if (recipe == null || level == null) {
			return class_1799.field_8037;
		}

		return recipe.method_8110(level.method_30349());
	}

	@Override
	protected int getRecipeHeight() {
		return 60;
	}
}
