package vazkii.patchouli.client.book.gui.button;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.book.Book;

public class GuiButtonBookMarkRead extends GuiButtonBook {

	private final Book book;

	public GuiButtonBookMarkRead(GuiBook parent, int x, int y) {
		super(parent, x, y, 308, 31, 11, 11, class_4185::method_25306, getTooltip(parent.book));
		this.book = parent.book;
	}

	@Override
	public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		int px = method_46426() + 1;
		int py = (int) (method_46427() + 0.5);
		GuiBook.drawFromTexture(graphics, book, method_46426(), method_46427(), 285, 160, 13, 10);
		GuiBook.drawFromTexture(graphics, book, px, py, u, v, field_22758, field_22759);
		if (method_25367()) {
			GuiBook.drawFromTexture(graphics, book, px, py, u + 11, v, field_22758, field_22759);
			parent.setTooltip(getTooltipLines());
		}
		graphics.method_51433(parent.getMinecraft().field_1772, "+", px, py, 0x00FF01, true);
	}

	@Override
	public void method_25306() {
		for (BookEntry entry : this.book.getContents().entries.values()) {
			if (isMainPage(this.book)) {
				markEntry(entry);
			} else {
				markCategoryAsRead(entry, entry.getCategory(), this.book.getContents().entries.size());
			}
		}
	}

	private void markCategoryAsRead(BookEntry entry, BookCategory category, int maxRecursion) {
		if (category.getName().equals(this.book.getContents().getCurrentGui().method_25440())) {
			markEntry(entry);
		} else if (!category.isRootCategory() && maxRecursion > 0) {
			markCategoryAsRead(entry, entry.getCategory().getParentCategory(), maxRecursion - 1);
		}
	}

	private void markEntry(BookEntry entry) {
		boolean dirty = false;
		var key = entry.getId();

		if (!entry.isLocked() && entry.getReadState().equals(EntryDisplayState.UNREAD)) {
			PersistentData.BookData data = PersistentData.data.getBookData(book);

			if (!data.viewedEntries.contains(key)) {
				data.viewedEntries.add(key);
				dirty = true;
				entry.markReadStateDirty();
			}
		}

		if (dirty) {
			PersistentData.save();
		}
	}

	private static class_2561 getTooltip(Book book) {
		String text = isMainPage(book) ? "patchouli.gui.lexicon.button.mark_all_read" : "patchouli.gui.lexicon.button.mark_category_read";
		return class_2561.method_43471(text);
	}

	private static boolean isMainPage(Book book) {
		return !book.getContents().currentGui.canSeeBackButton();
	}
}
