package vazkii.patchouli.client.book.gui;

import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.common.book.Book;

public class GuiBookWriter extends GuiBook {

	private BookTextRenderer text, editableText;
	private class_342 textfield;

	private static String savedText = "";
	private static boolean drawHeader;

	public GuiBookWriter(Book book) {
		super(book, class_2561.method_43473());
	}

	@Override
	public void method_25426() {
		super.method_25426();

		this.text = new BookTextRenderer(this, class_2561.method_43471("patchouli.gui.lexicon.editor.info"), LEFT_PAGE_X, TOP_PADDING + 20);
		this.textfield = new class_342(field_22793, 15, FULL_HEIGHT - 40, PAGE_WIDTH, 20, textfield, class_2561.method_43473());
		this.textfield.method_1880(Integer.MAX_VALUE);
		if (this.textfield.method_1882().isEmpty()) {
			this.textfield.method_1852(savedText);
		}
		this.editableText = new BookTextRenderer(this, class_2561.method_43470(""), RIGHT_PAGE_X, TOP_PADDING + (drawHeader ? 22 : -4));

		method_37063(new GuiButtonBook(this, bookLeft + 115, bookTop + PAGE_HEIGHT - 36, 330, 9, 11, 11, this::handleToggleHeaderButton, class_2561.method_43471("patchouli.gui.lexicon.button.toggle_mock_header")));
		refreshText();
	}

	@Override
	void drawForegroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		super.drawForegroundElements(graphics, mouseX, mouseY, partialTicks);

		drawCenteredStringNoShadow(graphics, class_1074.method_4662("patchouli.gui.lexicon.editor"), LEFT_PAGE_X + PAGE_WIDTH / 2, TOP_PADDING, book.headerColor);
		drawSeparator(graphics, book, LEFT_PAGE_X, TOP_PADDING + 12);

		if (drawHeader) {
			drawCenteredStringNoShadow(graphics, class_1074.method_4662("patchouli.gui.lexicon.editor.mock_header"), RIGHT_PAGE_X + PAGE_WIDTH / 2, TOP_PADDING, book.headerColor);
			drawSeparator(graphics, book, RIGHT_PAGE_X, TOP_PADDING + 12);
		}

		textfield.method_25394(graphics, mouseX, mouseY, partialTicks);
		text.method_25394(graphics, mouseX, mouseY, partialTicks);
		editableText.method_25394(graphics, mouseX, mouseY, partialTicks);
	}

	@Override
	public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
		if (textfield.method_25402(getRelativeX(mouseX), getRelativeY(mouseY), mouseButton)) {
			textfield.method_25365(true);
			return true;
		}
		if (text.click(mouseX, mouseY, mouseButton)) {
			return true;
		}
		if (editableText.click(mouseX, mouseY, mouseButton)) {
			return true;
		}
		return super.mouseClickedScaled(mouseX, mouseY, mouseButton);
	}

	@Override
	public boolean method_25404(int key, int scanCode, int modifiers) {
		if (textfield.method_25404(key, scanCode, modifiers)) {
			refreshText();
			return true;
		}

		return super.method_25404(key, scanCode, modifiers);
	}

	@Override
	public boolean method_25400(char c, int i) {
		if (textfield.method_25400(c, i)) {
			refreshText();
			return true;
		}

		return super.method_25400(c, i);
	}

	private void handleToggleHeaderButton(class_4185 button) {
		drawHeader = !drawHeader;
		method_25426();
	}

	private void refreshText() {
		savedText = textfield.method_1882();
		try {
			editableText.setText(class_2561.method_43470(savedText));
		} catch (Throwable e) {
			editableText.setText(class_2561.method_43470("[ERROR]"));
			PatchouliAPI.LOGGER.catching(e);
		}
	}
}
