package vazkii.patchouli.api;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;

/**
 * A context for a custom component's methods.
 */
public interface IComponentRenderContext {

	class_437 getGui();

	class_2583 getFont();

	void renderItemStack(class_332 graphics, int x, int y, int mouseX, int mouseY, class_1799 stack);

	void renderIngredient(class_332 graphics, int x, int y, int mouseX, int mouseY, class_1856 ingredient);

	boolean isAreaHovered(int mouseX, int mouseY, int x, int y, int w, int h);

	boolean navigateToEntry(class_2960 entry, int page, boolean push);

	@Deprecated // use setHoverTooltipComponents
	void setHoverTooltip(List<String> tooltip);

	void setHoverTooltipComponents(List<class_2561> tooltip);

	@Deprecated(forRemoval = true) // use addWidget
	void registerButton(class_4185 button, int pageNum, Runnable onClick);

	void addWidget(class_339 button, int pageNum);

	class_2960 getBookTexture();

	class_2960 getCraftingTexture();

	int getTextColor();

	int getHeaderColor();

	int getTicksInBook();
}
