package vazkii.patchouli.fabric.network;

import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.ClientBookRegistry;

import org.jetbrains.annotations.Nullable;


import io.netty.buffer.Unpooled;

public class FabricMessageOpenBookGui {
	public static final class_2960 ID = new class_2960(PatchouliAPI.MOD_ID, "open_book");

	public static void send(class_3222 player, class_2960 book, @Nullable class_2960 entry, int page) {
		class_2540 buf = new class_2540(Unpooled.buffer());
		buf.method_10812(book);
		buf.method_10814(entry == null ? "" : entry.toString());
		buf.method_10804(page);
		ServerPlayNetworking.send(player, ID, buf);
	}

	public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
		class_2960 book = buf.method_10810();
		class_2960 entry;
		String tmp = buf.method_19772();
		if (tmp.isEmpty()) {
			entry = null;
		} else {
			entry = class_2960.method_12829(tmp);
		}

		int page = buf.method_10816();
		client.method_20493(() -> ClientBookRegistry.INSTANCE.displayBookGui(book, entry, page));
	}

}
