package vazkii.patchouli.common.multiblock;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_6539;
import net.minecraft.class_7924;
import net.minecraft.world.level.*;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.TriPredicate;
import vazkii.patchouli.common.util.RotationUtil;

import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMultiblock implements IMultiblock, class_1920 {
	public class_2960 id;
	protected int offX, offY, offZ;
	protected int viewOffX, viewOffY, viewOffZ;
	private boolean symmetrical;
	class_1937 world;

	private final transient Map<class_2338, class_2586> teCache = new HashMap<>();

	@Override
	public IMultiblock offset(int x, int y, int z) {
		return setOffset(offX + x, offY + y, offZ + z);
	}

	public IMultiblock setOffset(int x, int y, int z) {
		offX = x;
		offY = y;
		offZ = z;
		return setViewOffset(x, y, z);
	}

	void setViewOffset() {
		setViewOffset(offX, offY, offZ);
	}

	@Override
	public IMultiblock offsetView(int x, int y, int z) {
		return setViewOffset(viewOffX + x, viewOffY + y, viewOffZ + z);
	}

	public IMultiblock setViewOffset(int x, int y, int z) {
		viewOffX = x;
		viewOffY = y;
		viewOffZ = z;
		return this;
	}

	@Override
	public IMultiblock setSymmetrical(boolean symmetrical) {
		this.symmetrical = symmetrical;
		return this;
	}

	@Override
	public class_2960 getID() {
		return id;
	}

	@Override
	public IMultiblock setId(class_2960 res) {
		this.id = res;
		return this;
	}

	@Override
	public void place(class_1937 world, class_2338 pos, class_2470 rotation) {
		setWorld(world);
		simulate(world, pos, rotation, false).getSecond().forEach(r -> {
			class_2338 placePos = r.getWorldPosition();
			class_2680 targetState = r.getStateMatcher().getDisplayedState(world.method_8510()).method_26186(rotation);

			if (!targetState.method_26215() && targetState.method_26184(world, placePos) && world.method_8320(placePos).method_45474()) {
				world.method_8501(placePos, targetState);
			}
		});
	}

	@Override
	public class_2470 validate(class_1937 world, class_2338 pos) {
		if (isSymmetrical() && validate(world, pos, class_2470.field_11467)) {
			return class_2470.field_11467;
		} else {
			for (class_2470 rot : class_2470.values()) {
				if (validate(world, pos, rot)) {
					return rot;
				}
			}
		}
		return null;
	}

	@Override
	public boolean validate(class_1937 world, class_2338 pos, class_2470 rotation) {
		setWorld(world);
		Pair<class_2338, Collection<SimulateResult>> sim = simulate(world, pos, rotation, false);

		return sim.getSecond().stream().allMatch(r -> {
			class_2338 checkPos = r.getWorldPosition();
			TriPredicate<class_1922, class_2338, class_2680> pred = r.getStateMatcher().getStatePredicate();
			class_2680 state = world.method_8320(checkPos).method_26186(RotationUtil.fixHorizontal(rotation));

			return pred.test(world, checkPos, state);
		});
	}

	@Override
	public boolean isSymmetrical() {
		return symmetrical;
	}

	public void setWorld(class_1937 world) {
		this.world = world;
	}

	@Override
	@Nullable
	public class_2586 method_8321(class_2338 pos) {
		class_2680 state = method_8320(pos);
		if (state.method_26204() instanceof class_2343) {
			return teCache.computeIfAbsent(pos.method_10062(), p -> ((class_2343) state.method_26204()).method_10123(pos, state));
		}
		return null;
	}

	@Override
	public class_3610 method_8316(class_2338 pos) {
		return class_3612.field_15906.method_15785();
	}

	@Override
	public abstract class_2382 getSize();

	@Override
	public float method_24852(class_2350 direction, boolean shaded) {
		return 1.0F;
	}

	@Override
	public class_3568 method_22336() {
		return null;
	}

	@Override
	public int method_23752(class_2338 pos, class_6539 color) {
		var plains = world.method_30349().method_30530(class_7924.field_41236)
				.method_31140(class_1972.field_9451);
		return color.getColor(plains, pos.method_10263(), pos.method_10260());
	}

	@Override
	public int method_8314(class_1944 type, class_2338 pos) {
		return 15;
	}

	@Override
	public int method_22335(class_2338 pos, int ambientDarkening) {
		return 15 - ambientDarkening;
	}

	// These heights were assumed based being derivative of old behavior, but it may be ideal to change
	@Override
	public int method_31605() {
		return 255;
	}

	@Override
	public int method_31607() {
		return 0;
	}
}
