package vazkii.patchouli.client.handler;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import com.mojang.datafixers.util.Pair;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.joml.Matrix4f;

import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData.Bookmark;
import vazkii.patchouli.common.multiblock.StateMatcher;
import vazkii.patchouli.common.util.RotationUtil;
import vazkii.patchouli.mixin.client.AccessorMultiBufferSource;

import java.awt.*;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293.class_5596;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_898;

public class MultiblockVisualizationHandler {

	public static boolean hasMultiblock;
	public static Bookmark bookmark;

	private static IMultiblock multiblock;
	private static class_2561 name;
	private static class_2338 pos;
	private static boolean isAnchored;
	private static class_2470 facingRotation;
	private static Function<class_2338, class_2338> offsetApplier;
	private static int blocks, blocksDone, airFilled;
	private static int timeComplete;
	private static class_2680 lookingState;
	private static class_2338 lookingPos;
	private static class_4597.class_4598 buffers = null;

	public static void setMultiblock(IMultiblock multiblock, class_2561 name, Bookmark bookmark, boolean flip) {
		setMultiblock(multiblock, name, bookmark, flip, pos -> pos);
	}

	public static void setMultiblock(IMultiblock multiblock, class_2561 name, Bookmark bookmark, boolean flip, Function<class_2338, class_2338> offsetApplier) {
		if (flip && hasMultiblock) {
			hasMultiblock = false;
		} else {
			MultiblockVisualizationHandler.multiblock = multiblock;
			MultiblockVisualizationHandler.name = name;
			MultiblockVisualizationHandler.bookmark = bookmark;
			MultiblockVisualizationHandler.offsetApplier = offsetApplier;
			pos = null;
			hasMultiblock = multiblock != null;
			isAnchored = false;
		}
	}

	public static void onRenderHUD(class_332 graphics, float partialTicks) {
		if (hasMultiblock) {
			int waitTime = 40;
			int fadeOutSpeed = 4;
			int fullAnimTime = waitTime + 10;
			float animTime = timeComplete + (timeComplete == 0 ? 0 : partialTicks);

			if (animTime > fullAnimTime) {
				hasMultiblock = false;
				return;
			}

			graphics.method_51448().method_22903();
			graphics.method_51448().method_46416(0, -Math.max(0, animTime - waitTime) * fadeOutSpeed, 0);

			class_310 mc = class_310.method_1551();
			int x = mc.method_22683().method_4486() / 2;
			int y = 12;

			graphics.method_27534(mc.field_1772, name, x, y, 0xFFFFFF);

			int width = 180;
			int height = 9;
			int left = x - width / 2;
			int top = y + 10;

			if (timeComplete > 0) {
				graphics.method_51448().method_22903();
				graphics.method_51448().method_46416(0, Math.min(height + 5, animTime), 0);
				graphics.method_27534(mc.field_1772, class_2561.method_43471("patchouli.gui.lexicon.structure_complete"), x, top + height - 10, 0x00FF00);
				graphics.method_51448().method_22909();
			}

			graphics.method_25294(left - 1, top - 1, left + width + 1, top + height + 1, 0xFF000000);
			drawGradientRect(graphics, left, top, left + width, top + height, 0xFF666666, 0xFF555555);

			float fract = (float) blocksDone / Math.max(1, blocks);
			int progressWidth = (int) ((float) width * fract);
			int color = class_3532.method_15369(fract / 3.0F, 1.0F, 1.0F) | 0xFF000000;
			int color2 = new Color(color).darker().getRGB();
			drawGradientRect(graphics, left, top, left + progressWidth, top + height, color, color2);

			if (!isAnchored) {
				graphics.method_27534(mc.field_1772, class_2561.method_43471("patchouli.gui.lexicon.not_anchored"), x, top + height + 8, 0xFFFFFF);
			} else {
				if (lookingState != null) {
					// try-catch around here because the state isn't necessarily present in the world in this instance,
					// which isn't really expected behavior for getPickBlock
					try {
						class_2248 block = lookingState.method_26204();
						class_1799 stack = block.method_9574(mc.field_1687, lookingPos, lookingState);

						if (!stack.method_7960()) {
							graphics.method_51439(mc.field_1772, stack.method_7964(), left + 20, top + height + 8, 0xFFFFFF, true);
							graphics.method_51427(stack, left, top + height + 2);
						}
					} catch (Exception ignored) {}
				}

				if (timeComplete == 0) {
					color = 0xFFFFFF;
					int posx = left + width;
					int posy = top + height + 2;
					int mult = 1;
					String progress = blocksDone + "/" + blocks;

					if (blocksDone == blocks && airFilled > 0) {
						progress = class_1074.method_4662("patchouli.gui.lexicon.needs_air");
						color = 0xDA4E3F;
						mult *= 2;
						posx -= width / 2;
						posy += 2;
					}

					graphics.method_51433(mc.field_1772, progress, posx - mc.field_1772.method_1727(progress) / mult, posy, color, false);
				}
			}

			graphics.method_51448().method_22909();
		}
	}

	public static void onWorldRenderLast(class_4587 ms) {
		if (hasMultiblock && multiblock != null) {
			renderMultiblock(class_310.method_1551().field_1687, ms);
		}
	}

	public static void anchorTo(class_2338 target, class_2470 rot) {
		pos = target;
		facingRotation = rot;
		isAnchored = true;
	}

	public static class_1269 onPlayerInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
		if (hasMultiblock && !isAnchored && player == class_310.method_1551().field_1724) {
			anchorTo(hit.method_17777(), getRotation(player));
			return class_1269.field_5812;
		}
		return class_1269.field_5811;
	}

	public static void onClientTick(class_310 mc) {
		if (class_310.method_1551().field_1687 == null) {
			hasMultiblock = false;
		} else if (isAnchored && blocks == blocksDone && airFilled == 0) {
			timeComplete++;
			if (timeComplete == 14) {
				class_310.method_1551().method_1483().method_4873(class_1109.method_4758(class_3417.field_14627, 1.0F));
			}
		} else {
			timeComplete = 0;
		}
	}

	public static void renderMultiblock(class_1937 world, class_4587 ms) {
		class_310 mc = class_310.method_1551();
		if (!isAnchored) {
			facingRotation = getRotation(mc.field_1724);
			if (mc.field_1765 instanceof class_3965) {
				pos = ((class_3965) mc.field_1765).method_17777();
			}
		} else if (pos.method_19770(mc.field_1724.method_19538()) > 64 * 64) {
			return;
		}

		if (pos == null) {
			return;
		}
		if (multiblock.isSymmetrical()) {
			facingRotation = class_2470.field_11467;
		}

		class_898 erd = mc.method_1561();
		double renderPosX = erd.field_4686.method_19326().method_10216();
		double renderPosY = erd.field_4686.method_19326().method_10214();
		double renderPosZ = erd.field_4686.method_19326().method_10215();
		ms.method_22903();
		ms.method_22904(-renderPosX, -renderPosY, -renderPosZ);

		if (buffers == null) {
			buffers = initBuffers(mc.method_22940().method_23000());
		}

		class_2338 checkPos = null;
		if (mc.field_1765 instanceof class_3965 blockRes) {
			checkPos = blockRes.method_17777().method_10093(blockRes.method_17780());
		}

		blocks = blocksDone = airFilled = 0;
		lookingState = null;
		lookingPos = checkPos;

		Pair<class_2338, Collection<IMultiblock.SimulateResult>> sim = multiblock.simulate(world, getStartPos(), getFacingRotation(), true);
		for (IMultiblock.SimulateResult r : sim.getSecond()) {
			float alpha = 0.3F;
			if (r.getWorldPosition().equals(checkPos)) {
				lookingState = r.getStateMatcher().getDisplayedState(ClientTicker.ticksInGame);
				alpha = 0.6F + (float) (Math.sin(ClientTicker.total * 0.3F) + 1F) * 0.1F;
			}

			if (r.getStateMatcher() != StateMatcher.ANY) {
				boolean air = r.getStateMatcher() == StateMatcher.AIR;
				if (!air) {
					blocks++;
				}

				if (!r.test(world, facingRotation)) {
					class_2680 renderState = r.getStateMatcher().getDisplayedState(ClientTicker.ticksInGame).method_26186(facingRotation);
					renderBlock(world, renderState, r.getWorldPosition(), alpha, ms);

					if (air) {
						airFilled++;
					}
				} else if (!air) {
					blocksDone++;
				}
			}
		}

		buffers.method_22993();
		ms.method_22909();

		if (!isAnchored) {
			blocks = blocksDone = 0;
		}
	}

	public static void renderBlock(class_1937 world, class_2680 state, class_2338 pos, float alpha, class_4587 ms) {
		if (pos != null) {
			ms.method_22903();
			ms.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());

			if (state.method_26204() == class_2246.field_10124) {
				float scale = 0.3F;
				float off = (1F - scale) / 2;
				ms.method_46416(off, off, -off);
				ms.method_22905(scale, scale, scale);

				state = class_2246.field_10058.method_9564();
			}

			class_310.method_1551().method_1541().method_3353(state, ms, buffers, 0xF000F0, class_4608.field_21444);

			ms.method_22909();
		}
	}

	public static IMultiblock getMultiblock() {
		return multiblock;
	}

	public static boolean isAnchored() {
		return isAnchored;
	}

	public static class_2470 getFacingRotation() {
		return multiblock.isSymmetrical() ? class_2470.field_11467 : facingRotation;
	}

	public static class_2338 getStartPos() {
		return offsetApplier.apply(pos);
	}

	private static void drawGradientRect(class_332 graphics, int left, int top, int right, int bottom, int startColor, int endColor) {
		float f = (float) (startColor >> 24 & 255) / 255.0F;
		float f1 = (float) (startColor >> 16 & 255) / 255.0F;
		float f2 = (float) (startColor >> 8 & 255) / 255.0F;
		float f3 = (float) (startColor & 255) / 255.0F;
		float f4 = (float) (endColor >> 24 & 255) / 255.0F;
		float f5 = (float) (endColor >> 16 & 255) / 255.0F;
		float f6 = (float) (endColor >> 8 & 255) / 255.0F;
		float f7 = (float) (endColor & 255) / 255.0F;
		RenderSystem.enableBlend();
		RenderSystem.blendFuncSeparate(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, GlStateManager.class_4535.ONE, GlStateManager.class_4534.ZERO);
		class_289 tessellator = class_289.method_1348();
		class_287 bufferbuilder = tessellator.method_1349();
		bufferbuilder.method_1328(class_5596.field_27382, class_290.field_1576);
		Matrix4f mat = graphics.method_51448().method_23760().method_23761();
		bufferbuilder.method_22918(mat, right, top, 0).method_22915(f1, f2, f3, f).method_1344();
		bufferbuilder.method_22918(mat, left, top, 0).method_22915(f1, f2, f3, f).method_1344();
		bufferbuilder.method_22918(mat, left, bottom, 0).method_22915(f5, f6, f7, f4).method_1344();
		bufferbuilder.method_22918(mat, right, bottom, 0).method_22915(f5, f6, f7, f4).method_1344();
		tessellator.method_1350();
		RenderSystem.disableBlend();
	}

	/**
	 * Returns the Rotation of a multiblock structure based on the given entity's facing direction.
	 */
	private static class_2470 getRotation(class_1297 entity) {
		return RotationUtil.rotationFromFacing(entity.method_5735());
	}

	private static class_4597.class_4598 initBuffers(class_4597.class_4598 original) {
		class_287 fallback = ((AccessorMultiBufferSource) original).getFallbackBuffer();
		Map<class_1921, class_287> layerBuffers = ((AccessorMultiBufferSource) original).getFixedBuffers();
		Map<class_1921, class_287> remapped = new Object2ObjectLinkedOpenHashMap<>();
		for (Map.Entry<class_1921, class_287> e : layerBuffers.entrySet()) {
			remapped.put(GhostRenderLayer.remap(e.getKey()), e.getValue());
		}
		return new GhostBuffers(fallback, remapped);
	}

	private static class GhostBuffers extends class_4597.class_4598 {
		protected GhostBuffers(class_287 fallback, Map<class_1921, class_287> layerBuffers) {
			super(fallback, layerBuffers);
		}

		@Override
		public class_4588 getBuffer(class_1921 type) {
			return super.getBuffer(GhostRenderLayer.remap(type));
		}
	}

	private static class GhostRenderLayer extends class_1921 {
		private static final Map<class_1921, class_1921> remappedTypes = new IdentityHashMap<>();

		private GhostRenderLayer(class_1921 original) {
			super(String.format("%s_%s_ghost", original.toString(), PatchouliAPI.MOD_ID), original.method_23031(), original.method_23033(), original.method_22722(), original.method_23037(), true, () -> {
				original.method_23516();

				RenderSystem.disableDepthTest();
				RenderSystem.enableBlend();
				RenderSystem.setShaderColor(1, 1, 1, 0.4F);
			}, () -> {
				RenderSystem.setShaderColor(1, 1, 1, 1);
				RenderSystem.disableBlend();
				RenderSystem.enableDepthTest();

				original.method_23518();
			});
		}

		public static class_1921 remap(class_1921 in) {
			if (in instanceof GhostRenderLayer) {
				return in;
			} else {
				return remappedTypes.computeIfAbsent(in, GhostRenderLayer::new);
			}
		}
	}

}
