package vazkii.patchouli.client.book.template.variable;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import vazkii.patchouli.common.util.ItemStackUtil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;

public class ItemStackArrayVariableSerializer extends GenericArrayVariableSerializer<class_1799> {
	public ItemStackArrayVariableSerializer() {
		super(new ItemStackVariableSerializer(), class_1799.class);
	}

	@Override
	public class_1799[] fromJson(JsonElement json) {
		if (json.isJsonArray()) {
			JsonArray array = json.getAsJsonArray();
			List<class_1799> stacks = new ArrayList<>();
			for (JsonElement e : array) {
				stacks.addAll(Arrays.asList(fromNonArray(e)));
			}
			return stacks.toArray(empty);
		}
		return fromNonArray(json);
	}

	public class_1799[] fromNonArray(JsonElement json) {
		if (json.isJsonNull()) {
			return empty;
		}
		if (json.isJsonPrimitive()) {
			return ItemStackUtil.loadStackListFromString(json.getAsString()).toArray(empty);
		}
		if (json.isJsonObject()) {
			return new class_1799[] { ItemStackUtil.loadStackFromJson(json.getAsJsonObject()) };
		}
		throw new IllegalArgumentException("Can't make an ItemStack from an array!");
	}

}
